/* $Id: sentinel.h,v 1.4 2000/04/22 07:38:23 bind Exp $ */

#include <stdio.h>
#include <strings.h>
#include <stdlib.h>
#include <unistd.h>
#include <libnet.h>
#include <pcap.h>
#include <pthread.h>
#include <sys/utsname.h>

#define VERSION "Version 0.8"

#define ON 1
#define OFF 0

#define NT 1      
#define UNIX 2

#define SNAPLEN 128
#define TIMEOUT 1024
#define OPTIMIZE 0

#define TCPHDRSIZE 20
#define UDPHDRSIZE 8
#define IPHDRSIZE  20
#define ETHHDRSIZE 14
#define DNSHDRSIZE 12

struct test {
  int dns;
  int arp;
  int latency;
  int ether;
  int ntether;
};

struct ether_addr *hwsource;

u_long dest, fake,source;
char *src, *dst, *device,*fke; 
char errbuf[256];
int offset, tag, num;
unsigned int network, netmask;
pthread_mutex_t pthread_mutex;

/* function prototypes */

void usage(char *);
void defaults(void);
void title(void);
pcap_t *pcap_init(char *);
void sighandler(int);
void result(char *, int);

int etherping(void);
void dns_generate(char *);

/* method function prototypes */

void *arp_sniff(void);
void *arp_send(void);
void *tcp_flood(void);
void *dns_sniff(void);
void *icmp_sniff(void);
void *icmp_send(void);

/* network packet structures */

struct udp_header {
	u_int16_t uh_sport;		/* source port */
	u_int16_t uh_dport;		/* destination port */
	u_int16_t uh_ulen;		/* udp length */
	u_int16_t uh_sum;		/* udp checksum */
};

struct dns_header {
  unsigned short int id;
  unsigned char   rd:1;		/* recursion desired */
  unsigned char   tc:1;		/* truncated message */
  unsigned char   aa:1;		/* authoritive answer */
  unsigned char   opcode:1;	/* purpose of message */
  unsigned char   qr:1;		/* response flag */
  unsigned char   rcode:1;	/* response code */
  unsigned char   unused:1;	/* unused bits */
  unsigned char   pr:1;		/* primary server required (non standard) */
  unsigned char   ra:1;		/* recursion available */
  unsigned short int que_num;
  unsigned short int rep_num;
  unsigned short int num_rr;
  unsigned short int num_rrsup;
};

struct ip_header {
#if BYTE_ORDER == LITTLE_ENDIAN
	u_int8_t  ip_hl:4,		/* header length */
		  ip_v:4;		/* version */
#endif
#if BYTE_ORDER == BIG_ENDIAN
	u_int8_t  ip_v:4,		/* version */
		  ip_hl:4;		/* header length */
#endif
	u_int8_t  ip_tos;		/* type of service */
	u_int16_t ip_len;		/* total length */
	u_int16_t ip_id;		/* identification */
	u_int16_t ip_off;		/* fragment offset field */
#define	IP_RF 0x8000			/* reserved fragment flag */
#define	IP_DF 0x4000			/* dont fragment flag */
#define	IP_MF 0x2000			/* more fragments flag */
#define	IP_OFFMASK 0x1fff		/* mask for fragmenting bits */
	u_int8_t  ip_ttl;		/* time to live */
	u_int8_t  ip_p;			/* protocol */
	u_int16_t ip_sum;		/* checksum */
	struct	  in_addr ip_src, ip_dst; /* source and dest address */
};

struct icmp_header {
	u_int8_t  icmp_type;		/* type of message, see below */
	u_int8_t  icmp_code;		/* type sub code */
	u_int16_t icmp_cksum;		/* ones complement cksum of struct */
	union {
		struct echo {
			  n_short id;
			  n_short seq;
		} idseq;
	} icmp_hun;
};

struct	arp_header {
	u_int16_t ar_hrd;	/* format of hardware address */
	u_int16_t ar_pro;	/* format of protocol address */
	u_int8_t  ar_hln;	/* length of hardware address */
	u_int8_t  ar_pln;	/* length of protocol address */
	u_int16_t ar_op;	/* one of: */
	u_int8_t  ar_sha[6];	/* sender hardware address */
	u_int8_t  ar_spa[6];	/* sender protocol address */
	u_int8_t  ar_tha[6];	/* target hardware address */
	u_int8_t  ar_tpa[6];	/* target protocol address */
};

