/* $Id: main.c,v 1.3 2000/04/22 07:12:53 bind Exp $ */

/* 
 *       [ The Sentinel Project: Remote promiscuous detection ]
 *                   [ Written by bind (c) 2000 ]
 *
 * Usage:
 *  ./sentinel [method] [-t <target ip>] [options]
 *
 * Methods:
 *  [ -a ARP test ]
 *  [ -d DNS test ]
 *  [ -i ICMP Ping Latency test  ]
 *  [ -e ICMP Etherping test ]
 *
 * Options:
 *  [ -f <non-existant host> ]
 *  [ -v Show version and exit ]
 *  [ -n <number of packets/seconds> ]
 *  [ -I <device> ]
 *
 */

#include "sentinel.h"

int main(int argc, char **argv)
{
  int optfd;
  extern char *optarg;
  extern int opterr;
  struct utsname hinfo;
  struct test test;
  pthread_t arp_send_thread, 
            arp_sniff_thread,
            dns_sniff_thread,
            tcp_flood_thread,
            icmp_sniff_thread,
            icmp_send_thread;

  num = 10;
  if(argc < 2) usage(argv[0]);

  opterr = 0;
  while((optfd = getopt(argc, argv, "diven:t:f:I:a")) != EOF) {
    switch(optfd) {
      case 'd': test.dns = ON; break;
      case 'e': test.ether = ON; break;
      case 'a': test.arp = ON; break;
      case 'i': test.latency = ON; break;
      case 'I': device = optarg; break;
      case 't': dst = optarg; break;
      case 'f': fke = optarg; 
                fake = libnet_name_resolve(optarg,0); 
                if(!fake) { 
                  printf("Cannot resolve: %s\n",optarg);
                  exit(1);
                }
                break;
      case 'n': num = atoi(optarg); break;
      case 'v': printf("%s\n",VERSION); exit(0);
      case '?':
      default: usage(argv[0]); break;
    }
  }

  if(geteuid()) {
    printf("get lost..\n");
    exit(1);
  }

  if(dst == NULL) usage(argv[0]);
  dest = libnet_name_resolve(dst,0);

  if(!dest) {
    printf("Unable to resolve: %s\n",dst);
    exit(1);
  }

  uname(&hinfo);

  if(test.dns == ON) 
    if(fke == NULL) { 
      printf("You must supply a fake host...\n");
      exit(1);
    }

  defaults();

  title();

  printf("\nRunning on: '%s' running on %s %s on a(n) %s\n\n",hinfo.nodename,hinfo.sysname,hinfo.release,hinfo.machine);

  printf("Device: %s\n",device);
  printf("Source IP Address: %s\n",src);
  printf("Source Hardware Address: ");
    printf("%x:%x:%x:%x:%x:%x\n",hwsource->ether_addr_octet[0],
                                 hwsource->ether_addr_octet[1],
                                 hwsource->ether_addr_octet[2],
                                 hwsource->ether_addr_octet[3],
                                 hwsource->ether_addr_octet[4],
                                 hwsource->ether_addr_octet[5]);

  printf("Target: %s\n",dst);
  if(test.dns == ON)
    printf("Fake Host: %s\n",fke);

  putchar('\n');

  if(test.latency == ON) { 
		  printf("Ping Latency test not implemented yet.\n"); 
  }

  if(test.arp == ON) 
  {
    tag = 0;
    printf("Performing ARP test\n");
    printf("Sending out %d bogus ARP requests",num);
    pthread_create(&arp_sniff_thread,NULL,(void *)arp_sniff,NULL);
    pthread_create(&arp_send_thread,NULL,(void *)arp_send,NULL);

    pthread_join(arp_sniff_thread,NULL);
    pthread_join(arp_send_thread,NULL);
  }

  if(test.ether == ON) 
  { 
    tag = 0;
    printf("Performing ICMP etherping test\n");
    printf("Sending out %d bogus ICMP ECHO packets",num);
    pthread_create(&icmp_sniff_thread,NULL,(void *)icmp_sniff,NULL);
    pthread_create(&icmp_send_thread,NULL,(void *)icmp_send,NULL);
    pthread_join(icmp_sniff_thread,NULL);
    pthread_join(icmp_send_thread,NULL);
  }

  if(test.dns == ON) 
  {
    tag = 0;
    dns_generate(fke);
    printf("Performing DNS Resolve test.\n");
    printf("Creating %d fake TCP connections",num);
    
    pthread_create(&dns_sniff_thread,NULL,(void *)dns_sniff,NULL);
    pthread_create(&tcp_flood_thread,NULL,(void *)tcp_flood,NULL);
   
    pthread_join(dns_sniff_thread,NULL);
    pthread_join(tcp_flood_thread,NULL);
  }

  return 0;
}

void usage(char *arg)
{
  title(); 
  printf("Usage:\n"
         "  %s [method] [-t <target ip>] [options]\n\n" 
         "Methods:\n"
         "  [ -a ARP test ]\n"
         "  [ -d DNS test ] (requires -f (non-existent host) option\n"
         "  [ -i ICMP Ping Latency test  ]\n"
         "  [ -e ICMP Etherping test ]\n\n"
         "Options:\n"
         "  [ -f <non-existant host> ]\n"
         "  [ -v Show version and exit ]\n"
         "  [ -n <number of packets/seconds> ]\n"
         "  [ -I <device> ]\n\n" ,arg);
          
  exit(1);
}

void defaults(void) 
{
  pcap_t *sock;
  int i, datalink;

  struct libnet_link_int l;

  if(device == NULL) {
     device = pcap_lookupdev(errbuf);
     if(device == NULL) {
       printf("error looking up device, try using -I\n");
       exit(1);
     }
  }
 
  if((sock = pcap_open_live(device,0,0,0,errbuf)) == NULL) {
    printf("error opening device: %s\n",errbuf);
    exit(1);
  }

  datalink = pcap_datalink(sock);

  pcap_close(sock);

  switch(datalink) {
    case DLT_EN10MB: offset=14; break;
    case DLT_NULL: 
    case DLT_PPP:
    default:
      printf("%s does not use a supported datalink type.\n",device);
      exit(0);
      break;
  }

  bzero(errbuf,sizeof(errbuf));

  /* read ip address from device */
  i = libnet_get_ipaddr(&l, device, errbuf);
  if(!i) { 
    fprintf(stderr,"Cannot get ip address from default device, try -I\n");
    exit(1); 
  }
  else (src = libnet_host_lookup(ntohl(i),0));

  /* read hw address from device */
  hwsource = libnet_get_hwaddr(&l, device, errbuf);
  if(!hwsource) {
    printf("Unable to get hardware address..try -I\n");
    exit(1);
  }

  source = libnet_name_resolve(src,0);
} 
  
void title(void) 
{
  printf("\n            [ The Sentinel Project: Remote promiscuous detection ]\n"
         "                    [ Subterrain Security Group (c) 2000 ]\n\n");
}
