/* $Id: arp.c,v 1.3 2000/04/22 07:38:23 bind Exp $ */

#include "sentinel.h"

void *arp_sniff(void)
{
  pcap_t *socket;
  u_char *pkt;
  struct pcap_pkthdr pcap_h;
  struct arp_header *arp;
  char filter[25];
  int temp = 0;

  bzero(&pthread_mutex,sizeof(pthread_mutex));

  snprintf(filter,25,"arp src host %s",dst);
  socket = pcap_init(filter);
  
  while(1) {

    usleep(1000);

    pkt = (u_char *)pcap_next(socket,&pcap_h);

    if(pkt != NULL) {

      arp = (struct arp_header *)(pkt + offset);

      if(ntohs(arp->ar_op) == 2) {
        pthread_mutex_lock(&pthread_mutex);
        tag = 1;
        pthread_mutex_unlock(&pthread_mutex);
        result("arp",1);
	pcap_close(socket);
        pthread_exit(0);
      }
    }
    pthread_mutex_lock(&pthread_mutex);
    temp = tag;
    pthread_mutex_unlock(&pthread_mutex);
    if(temp == 2) 
      break;
  }
  pcap_close(socket);
  result("arp",0);
  pthread_exit(0);
}

void *arp_send(void) 
{
  u_char *pkt;
  struct libnet_link_int *link;
  extern u_char fakeaddr[6];
  u_char defaddr[6] = {0,0,0,0,0};
  int count = 0, temp =0;

  link = libnet_open_link_interface(device,errbuf);
  if(!link) {
    perror("libnet_link_init");
    exit(-1);
  }

  if(libnet_init_packet(LIBNET_ARP_H + LIBNET_ETH_H, &pkt) < 0) {
    perror("libnet_init_packet");
    exit(1);
  }

  libnet_build_ethernet(fakeaddr,fakeaddr,ETHERTYPE_ARP,NULL,0,pkt);
  
  libnet_build_arp(ARPHRD_ETHER,ETHERTYPE_IP, 6, 4, ARPOP_REQUEST,
    (u_char *)hwsource, (u_char *)&source, defaddr,(u_char *)&dest, NULL,
    0, pkt + ETH_H); 

  while(1) {
    count++;
    printf("."); fflush(stdout);
    sleep(1);

    libnet_write_link_layer(link, device, pkt, LIBNET_ARP_H + LIBNET_ETH_H);
   
    pthread_mutex_lock(&pthread_mutex);
    temp = tag;
    pthread_mutex_unlock(&pthread_mutex);

    if(temp == 1) 
        break;

    if(count == num) { 
      pthread_mutex_lock(&pthread_mutex);
      tag = 2;
      pthread_mutex_unlock(&pthread_mutex);
      break;
    }
  }

  libnet_destroy_packet(&pkt);
  libnet_close_link_interface(link);
  pthread_exit(0);
}

