/* to_str.h
 * Definitions for utilities to convert various other types to strings.
 *
 * $Id: to_str.h,v 1.12 2002/12/09 21:34:58 guy Exp $
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@ethereal.com>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __TO_STR_H__
#define __TO_STR_H__

#include <glib.h>

#include "nstime.h"

/*
 * Resolution of a time stamp.
 */
typedef enum {
	MSECS,	/* milliseconds */
	USECS,	/* microseconds */
	NSECS	/* nanoseconds */
} time_res_t;

/*
 * These are utility functions which convert various types to strings,
 * but for which no more specific module applies.
 */

struct     e_in6_addr;

extern gchar*	ether_to_str(const guint8 *);
extern gchar*	ip_to_str(const guint8 *);
extern void	ip_to_str_buf(const guint8 *, gchar *);
extern gchar*	fc_to_str(const guint8 *);
extern gchar*	fcwwn_to_str (const guint8 *);
extern char*	ip6_to_str(const struct e_in6_addr *);
extern gchar*	ipx_addr_to_str(guint32, const guint8 *);
extern gchar*	ipxnet_to_string(const guint8 *ad);
extern gchar*	ipxnet_to_str_punct(const guint32 ad, char punct);
extern gchar*	vines_addr_to_str(const guint8 *addrp);
extern gchar*	time_secs_to_str(guint32);
extern gchar*	time_msecs_to_str(guint32);
extern gchar*	abs_time_to_str(nstime_t*);
extern void	display_signed_time(gchar *, int, gint32, gint32, time_res_t);
extern gchar*	rel_time_to_str(nstime_t*);
extern gchar*	rel_time_to_secs_str(nstime_t*);


extern char	*decode_bitfield_value(char *buf, guint32 val, guint32 mask,
    int width);
extern const char *decode_boolean_bitfield(guint32 val, guint32 mask, int width,
  const char *truedesc, const char *falsedesc);
extern const char *decode_numeric_bitfield(guint32 val, guint32 mask, int width,
  const char *fmt);

#endif /* __TO_STR_H__  */
