/*	 ui.cpp
 *	 
 *	 Recover v1.2
 *	 (C) 1999-2000 by Tom Pycke <Tom.Pycke@advalvas.be>
 *
 *	 This utility automates some steps as described
 *	 in the Ext2fs-Undeletion howto by Aaron Crane 
 *	 (http://pobox.com/~aaronc/tech/e2-undel/howto.txt)
 *	 in order to recover a lost file.
 *	 There is absolutely NO WARRANTY. But there is no
 *	 huge risk losing any data (as far as i know).
 *	 This program is made using kernel version 2.2.6
 *	 and e2fsprogs v1.14 which should come with your
 *	 distribution.
 *	 Normally, it should also work with other versions.
 *	 Just let me know if there seems to be a problem.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <ctype.h>
#include "questions.h"
#include "recover.h"

extern int filter_inode (inode *firstinode, inode_list *startinode, int userid,
		 int minsize, int maxsize, char *month, 
		 char *weekd, int minday, int maxday,
		 int minhour, int maxhour, int minmin,
		 int maxmin, int minsec, int maxsec, int year);
extern inode *get_inodes (char *device);
extern void strtoupper (char *str);
extern int check_week ( char *day );
extern int check_month ( char *month );
extern FILE *get_output ( char *command );

char *questions[17];

char device_list[15][9] = {
	"/dev/hda", "/dev/hdb", "/dev/hdc", "/dev/hdd", "/dev/sda",
	"/dev/sdb", "/dev/sdc", "/dev/sdd", "/dev/sde", "/dev/sdf",
	"/dev/sdg", "/dev/sdh", "/dev/sdi", "/dev/sdj", "/dev/sdk"
};


// prints an error. I use this functions because it
// can be changed for gtk an qt
void prn_error (char *message)
{
	printf ("recover: %s\n", message);
}

int searchfile (FILE *the_file, char *expr)
{
	int the_char=1,
	count;
	if (the_file == NULL) {
		//fclose (the_file);
		return 0;
	}
	for (; the_char != EOF ;) {	
		the_char = toupper (fgetc (the_file));
		if (the_char == expr[0])
			for (count=1;;count++) {
				the_char = toupper(fgetc (the_file));
				if (expr[count] == '\0') {
					fclose (the_file);
					return 1;
				}
				else if (the_char != expr[count])
					break;
		}
	}
	fclose (the_file);
	return 0;
}




// This function prints a list of all ext2 devices
int print_devices()
{
	char	*tmp=(char*) malloc(125),
		*buf=(char*) malloc(101),
		ext2_fs[256][100],
		ext2_fs_root[256][100],
		fs_type[20];
	int	count=0,
		part,
		dev,
		ext2_fs_count=0,
		counter=1;
	FILE *file;
	printf ("Scanning devices...\n");

	file = fopen ("/etc/fstab", "r");
	for (;counter!= EOF;) {
		counter=fscanf (file, "%s%s%s", &ext2_fs[ext2_fs_count],
				&ext2_fs_root[ext2_fs_count], &fs_type);
		if (strcmp (fs_type, "ext2") == 0 && ext2_fs[ext2_fs_count][0]=='/')
			ext2_fs_count++;
	}
	fclose (file);

	for (dev=0; dev<15; dev++) {
		sprintf (tmp,"%s", device_list[dev]);
		file = fopen (tmp, "r");
		if (file == NULL || fread (buf, 99, 1, file) != 1 )
			continue;
		for (part=1;part<16;part++) {
			sprintf (tmp,"%s%d", device_list[dev], part);
			file = fopen (tmp, "r");
			if (file == NULL || fread (buf, 99, 1, file) != 1)
				continue;
			printf ("%s: Valid partition", tmp);
			for (counter=0; counter<=ext2_fs_count; counter++) {
				if (strcmp (tmp, ext2_fs[counter]) == 0) {
					printf ("	type: ext2	mount point: %s", ext2_fs_root[counter]);
					ext2_fs[counter][0] = '0';
				}
			}
			count++;
			printf ("\n");
		}
	}
	for (counter=0; counter<=ext2_fs_count; counter++) {
		if (ext2_fs[ext2_fs_count][0]=='/') {
			printf ("%s: Valid partition(?)   type: ext2  mount point: %s", ext2_fs[counter], ext2_fs_root[counter]);
			ext2_fs[counter][0] = '0';
		}
	}
	if (count == 0)
		prn_error ("No valid standard devices found; are you a privileged user?\n");
	free (tmp);
	free (buf);
	if (file != NULL)
		fclose (file);
}

// prints a list of UID's with users from /etc/passwd
void print_uid()
{
	char name[100], number[50];
	int x, y, z, temp;
	char login[]="Name", uid[]="User ID", line[]="----------------------";
	FILE *passwd_file;
	passwd_file = fopen ("/etc/passwd", "r");
	printf ("\n%12s : %s\t|%12s : %s\t|%12s : %s\t|\n",
	login, uid, login, uid, login, uid);
	printf("%20s\t|%20s\t|%20s\t|\n", line, line, line);
	for (x=0;temp!=EOF;x++) {
		for (y=0;temp!=EOF && y<3;y++) {
			temp = getc(passwd_file);
			for (z=0;temp!=EOF && temp!=':';z++) {
				if (y==0)
					name[z] = temp;
				else if (y==2)
					number[z]=temp;
				temp = getc(passwd_file);
			}
			if (y==0)
				name[z] = 0;
			else if (y==2)
				number[z] = 0;
		}	
		for (; temp!='\n' && temp!=EOF;)
			temp = getc (passwd_file);
		printf ("%12s : %s\t|", name, number);
		if (x%3==2)
			printf("\n");
		temp=getc(passwd_file);
		if (temp==EOF)
			break;
		ungetc (temp, passwd_file);
	}
	fclose (passwd_file);
	printf ("\n");
}

// prints questions and get (decimal) answer (re-ask if bad anwer)
int get_int (int min, int max, char *question)
{
	int dec;
	static char tmp[12];
	do {
		printf ("%s", question);
		scanf ("%12s", &tmp);
		dec = atoi (tmp);
	} while ((dec > max || dec < min) && dec != -1);
	return dec;
}

void start_it (char *device1, int all)
{
	int	year,
		maxday, minday,
		maxmin, minmin,
		maxhour, minhour,
		uid, ch;
	int	minsize, maxsize, 
		result, inode_numb, count;
	char	weekd[4], month[4],
		*device=(char*)malloc (18),
		dir[126],
		*command=(char*)malloc(256),
		text_str[512],
		 *buf=(char*) malloc (101), c;
	inode *firstinode;
	inode_list *startinode, *tmp_inode;
	FILE *tmp;

	startinode = (inode_list *)malloc (sizeof (inode_list));
	if (device1 != NULL) {
		if (access (device1, F_OK) == 0) {
			firstinode = get_inodes (device1);
			strcpy (device, device1);
			goto start_questions;
		}
		else {
			sprintf (command, "cannot access %s", device1);
			prn_error(command);
			exit (1);
		}
	}
start_device:
#ifndef lsdel_file
	print_devices();
	printf ("Done printing devices\n");
#endif
start_ask_device:
	printf ("%s", ask_device);
	scanf ("%12s", device);
	tmp = fopen (device, "r");
	if (access (device, F_OK) != 0)
		goto start_ask_device;
	if (tmp == NULL)
		goto start_ask_device;
	if (fread (buf, 99, 1, tmp)!=1) {
		fclose (tmp);	
		goto start_ask_device;
	}
	fclose (tmp);
	firstinode = get_inodes (device);
start_questions:
	if (all == 1) {
		year = -1;
		month[0] = '-'; month[1] = '1'; month[2] = '\0';
		weekd[0] = '-'; weekd[1] = '1'; weekd[2] = '\0';
		minday = 0;
		maxday = 31;
		minhour = 0;
		maxhour = 23;
		minmin = 0;
		maxmin = 59;
		minsize = 0;
		maxsize = MAX_FILE;
		uid = -1;
		goto filter_it;
	}
	printf ("\n");
	year = get_int (1980, 2999, ask_year);
month_question:
	printf("%s", ask_month);
	printf("%s", month_eg);
	scanf("%3s", &month);
	if (!check_month (month) )
		goto month_question;
	if (!strcmp(month,"-1"))
		printf("Aborting month\n");

weekd_question:
	printf("%s", ask_weekd);
	printf("%s", weekd_eg);
	scanf("%3s", &weekd);
	if (!check_week (weekd) )
		goto weekd_question;
	if (!strcmp(weekd,"-1"))
		printf("Aborting weekday\n");

	minday = get_int (1, 31, ask_day1);
	maxday = get_int (1, 31, ask_day2);
	minhour = get_int (0, 23, ask_hour1);
	maxhour = get_int (0, 23, ask_hour2);
	minmin = get_int (0, 59, ask_min1);
	maxmin = get_int (0, 59, ask_min2);
	minsize = get_int (0, MAX_FILE, ask_minsize);
	maxsize = get_int (0, MAX_FILE, ask_maxsize);
	print_uid();
	uid = get_int (-5, 999999, ask_id);

filter_it:
	result = filter_inode (firstinode, startinode, uid, minsize, maxsize, month,
		weekd, minday, maxday, minhour, maxhour, minmin, maxmin,
		0, 60, year);
	if (result == 0)
		printf ("No inodes found");
	if (startinode != NULL && result > 0) {
		printf ("\n%d %s ", result, ask_dump);
		scanf ("%125s", &dir);
		//sprintf (command, "mkdir %s &> /dev/null", dir);
		//tmp = get_output (command);
		//fclose (tmp);
		mkdir (dir, S_IRUSR | S_IWUSR);
		tmp_inode = startinode;		

		getchar();
		printf ("\nPlease type some text the deleted file should have included (type: * if you don't know it): ");
		for (count=0; count < 512 && (c=getchar())!=EOF && c!='\n'; count++) {
			text_str[count]=c;
			if (c=='\b')
			count--;
		}
		text_str[count]='\0';
		strtoupper (text_str);
		printf ("\nPlease wait...\n");
		for (;tmp_inode!=NULL; tmp_inode=tmp_inode->next_inode) {
			//printf ("=> %d\n", startinode->number);
			inode_numb=tmp_inode->number;
			sprintf (command, "debugfs %s -R \'cat <%d>\' 2> /dev/null", 
					device, inode_numb);
			wait ((void *)0);
			tmp = get_output (command);
			//fclose (tmp);
			if (searchfile (tmp, text_str)==1 || (text_str[0]=='*' && text_str[1]=='\0')) {
				sprintf (command, "debugfs %s -R \'dump <%d> %s/dump%d\' > /dev/null &> /dev/null", device, inode_numb, dir, inode_numb);
				printf ("Dumping inode %d to %s\n", inode_numb, dir);
				tmp = get_output (command);
				wait ((void *)0);
				fclose (tmp);
				sprintf (command, "%s/dump%d", dir, inode_numb);
				// restore the original user and mode (if possible)
				chown (command, tmp_inode->mem_location->UID, 0);
				chmod (command, tmp_inode->mem_location->mode);
			}
		}
	}


ask_redo:
	printf ("\n%s[yn] ", ask_refilter);
	ch = getchar();
	if (ch == 'n' )
		return;
	if (ch == 'y')
		goto start_questions;
	else
		goto ask_redo;
}
