/*	 recover.h
 *
 *	 Recover v1.2
 *	 (C) 1999-2000 by Tom Pycke <Tom.Pycke@advalvas.be>
 *
 *	 This utility automates some steps as described
 *	 in the Ext2fs-Undeletion howto by Aaron Crane 
 *	 (http://pobox.com/~aaronc/tech/e2-undel/howto.txt)
 *	 in order to recover a lost file.
 *	 There is absolutely NO WARRANTY. But there is no
 *	 huge risk losing any data (as far as i know).
 *	 This program is made using kernel version 2.2.6
 *	 and e2fsprogs v1.14 which should come with your
 *	 distribution.
 *	 Normally, it should also work with other versions.
 *	 Just let me know if there seems to be a problem.
 *
 */

//#define lsdel_file
#undef lsdel_file
#define QUESTIONS_LOCATION "/usr/share/recover/recover_questions"
#define INIT_STR "Recover v1.2 by Tom Pycke <Tom.Pycke@advalvas.be>"
#undef DEBUG

typedef struct inode {
	int number;
	int UID;
	int mode;
	int size;
	char month[4];
	char weekd[4];
	int day;
	int hour;
	int min;
	int sec;
	int year;
	struct inode *next_inode;
} inode;

typedef struct inode_list {
	int number;
	inode *mem_location;
	struct inode_list *next_inode;
} inode_list;

