#!/usr/bin/perl
#
#  This program is a modified version of the mactime program by 
#  Dan Farmer and Venema Wieste
#
#  This program will take from standard in the output from the body file collected 
#  while recursively going through directories on the system
#
#  There are no options within this program.  This is a stripped down version that main 
#  use is to allow for the main program to be run from a floppy disk and its output 
#  written to standard out with the intention of being sent through a netcat tunnel
#  to an analysis machine.
#
#  This will allow for file analysis without fear of writing or adjusting the victim
#  system.  
#
#  modifications by Rob Lee		rob@karrde.com

$debug = 0; 
use lib "./";

use Date::Manip;

%month_to_digit = ("Jan", 1, "Feb", 2, "Mar", 3, "Apr", 4, "May", 5, "Jun", 6,
	"Jul", 7, "Aug", 8, "Sep", 9, "Oct", 10, "Nov", 11, "Dec", 12);
%digit_to_month = ("01", "Jan", "02", "Feb", "03", "Mar", "04", "Apr", "05", 
	"May", "06", "Jun", "07", "Jul", "08", "Aug", "09", "Sep", "10", 
	"Oct", "11", "Nov", "12", "Dec");

$GROUP = "/etc/group"; 
$PASSWD = "/etc/passwd"; 


# Load the password stuff
&'load_passwd_info(0,$PASSWD);
&'load_group_info(0,$GROUP);

#
# Suck in the Super_Tree Output
#

while (<STDIN>) {

	($md5,$file,$st_dev,$st_ino,$st_mode,$st_ls,$st_nlink,$st_uid,$st_gid,
	$st_rdev,$st_size,$st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks)
		= &tm_split($_);

	#
	# make symlinks point to the real file, like ls(1)
	#
	($st_ls, $x, $real_ls) = split(/\s/, $st_ls);
	if ($real_ls) { $symlinks{$file} = $real_ls; }


	print "STAT: $md5,$file,$st_dev,$st_ino,$st_mode,$st_ls,$st_nlink,
	$st_uid,$st_gid, $st_rdev,$st_size,A: $st_atime,M: $st_mtime,
	C: $st_ctime,$st_blksize,$st_blocks\n" if $debug;

	print "STAT: $file A: $st_atime M: $st_mtime C: $st_ctime\n" if $debug;

	#
	# if name is already used...
	#
	if (defined($all_filenames{$file})) {
		warn "filename already seen - $file!\n" if $debug;
		next;
		}

	#
	# we need *some* value in mactimes!
	#
	# next if (!$st_atime || !$st_mtime || !$st_ctime);
	if (!$st_atime || !$st_mtime || !$st_ctime) {
		warn "$file MAC ==> $st_mtime/$st_atime/$st_ctime\n";
		next;
		}

	#
	#  First, put all the times in one big array...
	#

	#
	# If the date on the file is too old, don't put it in the array
	#
	$all_files_used{"$st_mtime,$file"} .= "m" if $st_mtime > $in_seconds;
	$all_files_used{"$st_atime,$file"} .= "a" if $st_atime > $in_seconds;
	$all_files_used{"$st_ctime,$file"} .= "c" if $st_ctime > $in_seconds;

	$all_filenames{$file} = $file;

	# $all_file_modes{$file} = $st_mode;

	#
	#  Then dump the file mode, owner, group, & size into arrays
	#
	# $all_file_modes{$file} = $st_mode;
	# $all_file_uids{$file}  = $uid2names{$st_uid};
	# $all_file_gids{$file}  = $gid2names{$st_gid};
	# $all_file_sizes{$file} = $st_size;

	# we want *something* in these!  Uids are fine if they don't map
	if ($uid2names{$st_uid} eq "") { $uid2names{$st_uid} = $st_uid; }
	if ($gid2names{$st_gid} eq "") { $gid2names{$st_gid} = $st_gid; }

	#
	# put /'s between multiple UID/GIDs
	#
	$uid2names{$st_uid} =~ s@\s@/@g;
	$gid2names{$st_gid} =~ s@\s@/@g;

	$all_files{$file} = "$st_ls:$uid2names{$st_uid}:$gid2names{$st_gid}:$st_size" if (($st_mtime > $in_seconds)|| 
	  ($st_atime > $in_seconds)||
	  ($st_ctime > $in_seconds));

	}


#
#  The purpose of the program - print out the results!
#
print "Start Time: $time_one, $in_seconds\n" if $debug;
print "Current Tm: ", time, "\n" if $debug;
print "Start of Time Selected ($time_one)\n" if $debug;

for $key (sort keys %all_files_used) {
	($time, $file) = split(/,/,$key);
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)=localtime($time);

	# the month here is 0-11, not 1-12, like what we want
	$mon++;

	print "\t($sec,$min,$hour,MDay: $mday,M: $mon,$year,$wday,$yday,$isdst) = ($time)\n" if $debug;
	#
	# mark the end of time2, the end of the time span desired
	#

	print "T-in minus Curr = ", $in_seconds - $time, "\n" if $debug;
	next if ($in_seconds > $time);

	# print "\n$time\t$all_files_used{$key}\t$file\n";
	#
	# cosmetic change to make it look like unix dates
	#
	$mon   = "0$mon"   if $mon   < 10;
	$mday  = "0$mday"  if $mday  < 10;
	$hour  = "0$hour"  if $hour  < 10;
	$min   = "0$min"   if $min   < 10;
	$sec   = "0$sec"   if $sec   < 10;

	#
	#  How do we print the date?
	#
	$yeart=$year+1900;
		$date_string = "$digit_to_month{$mon} $mday $yeart $hour:$min:$sec";

	#
	# However, we only print the date if it's different from the one 
	# above.  We need to fill the empty space with blanks, though.
	#
	if ($old_date_string eq $date_string) {
		$date_string = " ";
		}
	else { $old_date_string = $date_string; }

	#
	#  Muck around with the [mac]times string to make it pretty.
	# If it has all three times, leave it alone.
	#
	$mactime = $all_files_used{$key};
	if (length($mactime) == 2) {
		$one = substr($mactime, 0, 1);
		$two = substr($mactime, 1, 1);
		if ($one eq "a")    { $mactime = ".$mactime"; }
		elsif ($one eq "m") { 
			if ($two eq "a") { $mactime = "$mactime."; }
			else             { $mactime = "$one.$two"; }
			}
		}
	elsif (length($mactime) == 1) {
		$one = substr($mactime, 0, 1);
		if    ($one eq "m") { $mactime = "$mactime.."; }
		elsif ($one eq "a") { $mactime = ".$mactime."; }
		elsif ($one eq "c") { $mactime = "..$mactime"; }
		}

	($ls,$uids,$groups,$size) = split(/:/, $all_files{$file});

	print "FILE: $file MODES: $ls U: $uids G: $groups S: $size\n" if $debug;

		printf("%20s %8s %3s %s %-8s %-8s %s\n", 
		$date_string, $size, $mactime, $ls, $uids, $groups, $file);
	}



#
#   Routines for reading and caching user and group information.  These
# are used in multiple programs... it caches the info once, then hopefully
# won't be used again.
#
#  Steve Romig, May 1991.
#
# Provides a bunch of routines and a bunch of arrays.  Routines 
# (and their usage):
#
#    load_passwd_info($use_getent, $file_name)
#
#	loads user information into the %uname* and %uid* arrays 
#	(see below).  
#
#	If $use_getent is non-zero:
#	    get the info via repeated 'getpwent' calls.  This can be
#	    *slow* on some hosts, especially if they are running as a
#	    YP (NIS) client.
#	If $use_getent is 0:
#	    if $file_name is "", then get the info from reading the 
#	    results of "ypcat passwd" and from /etc/passwd.  Otherwise, 
#	    read the named file.  The file should be in passwd(5) 
#	    format.
#
#    load_group_info($use_gentent, $file_name)
#
#	is similar to load_passwd_info.
#
# Information is stored in several convenient associative arrays:
#
#   %uname2shell	Assoc array, indexed by user name, value is 
#			shell for that user name.
#
#   %uname2dir		Assoc array, indexed by user name, value is
#			home directory for that user name.
#
#   %uname2uid		Assoc array, indexed by name, value is uid for 
#			that uid.
#			
#   %uname2passwd	Assoc array, indexed by name, value is password
#			for that user name.
#
#   %uid2names		Assoc array, indexed by uid, value is list of
#			user names with that uid, in form "name name
#			name...". 
#
#   %gid2members	Assoc array, indexed by gid, value is list of
#			group members in form "name name name..."
#
#   %gname2gid		Assoc array, indexed by group name, value is
#			matching gid.
#
#   %gid2names		Assoc array, indexed by gid, value is the
#			list of group names with that gid in form 
#			"name name name...".
#
# You can also use routines named the same as the arrays - pass the index 
# as the arg, get back the value.  If you use this, get{gr|pw}{uid|gid|nam} 
# will be used to lookup entries that aren't found in the cache.
#
# To be done:
#    probably ought to add routines to deal with full names.
#    maybe there ought to be some anal-retentive checking of password 
#	and group entries.
#    probably ought to cache get{pw|gr}{nam|uid|gid} lookups also.
#    probably ought to avoid overwriting existing entries (eg, duplicate 
#       names in password file would collide in the tables that are 
#	indexed by name).
#
# Disclaimer:
#    If you use YP and you use netgroup entries such as 
#	+@servers::::::
#	+:*:::::/usr/local/utils/messages
#    then loading the password file in with &load_passwd_info(0) will get 
#    you mostly correct YP stuff *except* that it won't do the password and 
#    shell substitutions as you'd expect.  You might want to use 
#    &load_passwd_info(1) instead to use getpwent calls to do the lookups, 
#    which would be more correct.
#
#
#  minor changes to make it fit with the TCT program, 9/25/99, - dan
#

package main;

$PASSWD = '/etc/passwd' unless defined $PASSWD;

%uname2shell = ();
%uname2dir = ();
%uname2uid = ();
%uname2passwd = ();
%uid2names = ();
%gid2members = ();
%gname2gid = ();
%gid2names = ();

$DOMAINNAME = "/bin/domainname" unless defined $DOMAINNAME;
$YPCAT = "/bin/ypcat" unless defined $YPCAT;

$yptmp = "./yptmp.$$";

$passwd_loaded = 0;		# flags to use to avoid reloading everything
$group_loaded = 0;		# unnecessarily...

#
# We provide routines for getting values from the data structures as well.
# These are named after the data structures they cache their data in.  Note 
# that they will all generate password and group file lookups via getpw* 
# and getgr* if they can't find info in the cache, so they will work
# "right" even if load_passwd_info and load_group_info aren't called to 
# preload the caches.
#
# I should point out, however, that if you don't call load_*_info to preload
# the cache, uid2names, gid2names and gid2members *will not* be complete, since 
# you must read the entire password and group files to get a complete picture.
# This might be acceptable in some cases, so you can skip the load_*_info
# calls if you know what you are doing...
#
sub uname2shell {
    local($key) = @_;

    if (! defined($uname2shell{$key})) {
	&add_pw_info(getpwnam($key));
    }

    return($uname2shell{$key});
}

sub uname2dir {
    local($key) = @_;
    local(@pw_info);

    if (! defined($uname2dir{$key})) {
	&add_pw_info(getpwnam($key));
    }

    return($uname2dir{$key});
}

sub uname2uid {
    local($key) = @_;
    local(@pw_info);

    if (! defined($uname2uid{$key})) {
	&add_pw_info(getpwnam($key));
    }

    return($uname2uid{$key});
}

sub uname2passwd {
    local($key) = @_;
    local(@pw_info);

    if (! defined($uname2passwd{$key})) {
	&add_pw_info(getpwnam($key));
    }

    return($uname2passwd{$key});
}

sub uid2names {
    local($key) = @_;
    local(@pw_info);

    if (! defined($uid2names{$key})) {
	&add_pw_info(getpwuid($key));
    }

    return($uid2names{$key});
}

sub gid2members {
    local($key) = @_;
    local(@gr_info);

    if (! defined($gid2members{$key})) {
	&add_gr_info(getgrgid($key));
    }

    return($gid2members{$key});
}

sub gname2gid {
    local($key) = @_;
    local(@gr_info);

    if (! defined($gname2gid{$key})) {
	&add_gr_info(getgrnam($key));
    }

    return($gname2gid{$key});
}

sub gid2names {
    local($key) = @_;
    local(@gr_info);

    if (! defined($gid2names{$key})) {
	&add_gr_info(getgrgid($key));
    }

    return($gid2names{$key});
}

#
# Update user information for the user named $name.  We cache the password, 
# uid, login group, home directory and shell.
#

sub add_pw_info {
    local($name, $passwd, $uid, $gid) = @_;
    local($dir, $shell);

#
# Ugh!  argh...yech...sigh.  If we use getpwent, we get back 9 elts, 
# if we parse /etc/passwd directly we get 7.  Pick off the last 2 and 
# assume that they are the $directory and $shell.  
#
    $num = ( $#_ >= 7 ? 8 : 6 );
    $dir = $_[$num - 1];
    $shell = $_[$num] || '/bin/sh';


    if ($name ne "") {
	$uname2shell{$name} = $shell;
	$uname2dir{$name} = $dir;
	$uname2uid{$name} = $uid;
	$uname2passwd{$name} = $passwd;

	if ($gid ne "") {
	    # fixme: should probably check for duplicates...sigh

	    if (defined($gid2members{$gid})) {
		$gid2members{$gid} .= " $name";
	    } else {
		$gid2members{$gid} = $name;
	    }
	}

	if ($uid ne "") {
	    if (defined($uid2names{$uid})) {
		$uid2names{$uid} .= " $name";
	    } else {
		$uid2names{$uid} = $name;
	    }
	}
    }
}

#
# Update group information for the group named $name.  We cache the gid 
# and the list of group members.
#

sub add_gr_info {
    local($name, $passwd, $gid, $members) = @_;

    if ($name ne "") {
	$gname2gid{$name} = $gid;

	if ($gid ne "") {
	    if (defined($gid2names{$gid})) {
		$gid2names{$gid} .= " $name";
	    } else {
		$gid2names{$gid} = $name;
	    }

	    # fixme: should probably check for duplicates

	    $members = join(' ', split(/[, \t]+/, $members));

	    if (defined($gid2members{$gid})) {
		$gid2members{$gid} .= " " . $members;
	    } else {
		$gid2members{$gid} = $members;
	    }
	}
    }
}

#
# We need to suck in the entire group and password files so that we can 
# make the %uid2names, %gid2members and %gid2names lists complete.  Otherwise,
# we would just read the entries as needed with getpw* and cache the results.
# Sigh.
#
# There are several ways that we might find the info.  If $use_getent is 1, 
# then we just use getpwent and getgrent calls to read the info in.
#
# That isn't real efficient if you are using YP (especially on a YP client), so
# if $use_getent is 0, we can use ypcat to get a copy of the passwd and
# group maps in a fairly efficient manner.  If we do this we have to also read
# the local /etc/{passwd,group} files to complete our information.  If we aren't 
# using YP, we just read the local password and group files.
#
sub load_passwd_info {
    local($use_getent, $file_name) = @_;
    local(@pw_info);

    if ($passwd_loaded) {
	return;
    }

    $passwd_loaded = 1;

    if ($'GET_PASSWD) {
	# open(GFILE, "$'GET_PASSWD|") || die "can't $'GET_PASSWD";
	&pipe_command(GFILE, "$'GET_PASSWD", "-");
	while (<GFILE>) {
		chop;
		&add_pw_info(split(/:/));
		}
	close(GFILE);
	}
    else {

    if ($use_getent) {
	#
	# Use getpwent to get the info from the system, and add_pw_info to 
	# cache it.
	#
	while (@pw_info = getpwent) {
	    &add_pw_info(@pw_info);
	}

	endpwent;

	return;
    } elsif ($file_name eq "") {
	# chop($has_yp = `$DOMAINNAME`);
	chop($has_yp = &command_to_string($DOMAINNAME));

	if ($has_yp) {
	    #
	    # If we have YP (NIS), then use ypcat to get the stuff from the 
	    # map.@
	    #
	    # system("$YPCAT passwd > $yptmp 2> /dev/null");
	    &redirect_command($YPCAT, "passwd", ">$yptmp");
	    if (-s $yptmp) {
		&pipe_command(FILE, $YPCAT, "passwd", "-|");
	    	while (<FILE>) {
			chop;
			&add_pw_info(split(/:/));
	    		}
	    	}
	    close(FILE);
	}

	#
	# We have to read /etc/passwd no matter what...
	#
	$file_name = "/etc/passwd";
    }

    open(FILE, $file_name) ||
      die "can't open $file_name";

    while (<FILE>) {
	chop;
	    
	if ($_ !~ /^\+/) {
	    &add_pw_info(split(/:/));
	}

	# fixme: if the name matches +@name, then this is a weird 
	# netgroup thing, and we aren't dealing with it right.  might want
	# to warn the poor user...suggest that he use the use_getent 
	# method instead.
    }
    }

    close(FILE);
}

sub load_group_info {
    local($use_getent, $file_name) = @_;
    local(@gr_info);

    if ($group_loaded) {
	return;
    }

    $group_loaded = 1;

    if ($use_getent) {
	#
	# Use getgrent to get the info from the system, and add_gr_info to 
	# cache it.
	#
	while ((@gr_info = getgrent()) != 0) {
	    &add_gr_info(@gr_info);
	}

	endgrent();

	return();
    } elsif ($file_name eq "") {
	# chop($has_yp = `$DOMAINNAME`);
	chop($has_yp = &command_to_string($DOMAINNAME));

	if ($has_yp) {
	    #
	    # If we have YP (NIS), then use ypcat to get the stuff from the 
	    # map.
	    #
	    # system("$YPCAT passwd > $yptmp 2> /dev/null");
	    &redirect_command($YPCAT, "passwd", ">$yptmp");
	    if (-s $yptmp) {
		&pipe_command(FILE, $YPCAT, "group", "-|");
	    	while (<FILE>) {
			chop;
			&add_gr_info(split(/:/));
	    		}
	    	close(FILE);
		}
	}

	#
	# We have to read /etc/group no matter what...
	#
	$file_name = "/etc/group";
    }

    open(FILE, $file_name) ||
      die "can't open $file_name";

    while (<FILE>) {
	chop;
	if ($_ !~ /^\+/) {
	    &add_gr_info(split(/:/));
	}

	# fixme: if the name matches +@name, then this is a weird 
	# netgroup thing, and we aren't dealing with it right.  might want
	# to warn the poor user...suggest that he use the use_getent 
	# method instead.
    }

    close(FILE);
}

# Load the password stuff -- Do NOT take this out!
# &'load_passwd_info($getpwent,$PASSWD);
# &'load_group_info($getpwent,$PASSWD);

unlink $yptmp;

1;

#
# Split a time machine record.
#
sub tm_split {
        local($line) = @_;
        local(@fields);

        for (@fields = split(/\|/, $line)) {
                s/%([A-F0-9][A-F0-9])/pack("C", hex($1))/egis;
        }
        return @fields;
}
1;




