#!/usr/bin/perl
#
#  This program is a modified version of the program found in the
#  Coroner's Toolkit developed by Dan Farmer  
#  
#  Usage perl macdaddy.pl $1   where $1 is the directory and subdirectories 
#  you want to analyze.  
#
#  The OUTPUT is written to standard out instead of a file so it doesn't write to the 
#  physical disk.  This is useful so you can netcat it across a network to another
#  machine.
# 
#  For example run on the victim
#  perl macdaddy.pl / | nc xxx.xxx.xxx.xxx 626 
#
#  And on the other side on your analysis machine
#  nc -l -p 626 > mactimes_victim
#
#  This does not have all the options the normal mactime program from the TCT
#  has.  It is intended to use on a first response where you need to gather evidence
#  while not adjusting or writing to the physical system in the process.
#  
#  modifications by Rob Lee	rob@karrde.com 
#  Original program by Dan Farmer and Venema Wieste
#
#

$directory=$ARGV[0];
open (MACTIME, "| ./mac_the_knife.pl");
&process_dir($directory);

sub process_dir {
local($dir) = @_;
local(\@dirs);

$debug=0;
$verbose=0;
$recursion=1;
print "going into process dir with \"$dir\"...\n" if $debug;

# others hate /proc...

return if ($dir =~ /^\/proc/);

print "processing dir $dir (in process_dir)\n" if $verbose;

if (defined($already_seen{$dir})) {
	print "We've already processed this directory ($dir), skipping...\n"
		if $debug;
	return;
	}

$already_seen{$dir} = 1;

if (!opendir(DIR, $dir)) {
#	warn "Can't open $dir via opendir (in process_dir())\n";
	return;
	}

#
# Suck in all the dir entries
@next = readdir(DIR);

#
#  If we're stupid enough to call this with a trailing slash in the
# filename, or if we call it with just "/", strip it off.
#
$dir =~ s@/$@@;

# 
# Go over each of the dir entries
while (($_ = pop(@next))) {
	print "next dir entry: $_\n" if $debug;

	# skip ".", "..", and null dir entries
	next if ($_ eq "\." || $_ eq "\.\." || ! $_);

	print "DIR: $dir\n" if $debug;

	#
	# Add the path to the filename
	$file = $_;	# (we'll need this in a bit)
	$_ = "$dir/$_";

	#
	#  What is the entry?  Gather it for processing based on type.
	# if (-f || (-d && $recursion))    { 
	if (-f || -d) {
		print "$_ Is -f\n" if $debug;
		# get rid of extra slashes...
		$_ =~ s@/+@/@g;
		push(@files, $_);
		#
		}
	if    (-f) { # dir is used above, need to use if statement
		     # to make sense of it all, else files (-f) will
		     # get confused.  Poor programming... ;-(
		   }
	elsif (-d) { print "$_ Is -d\n" if $debug; push(@dirs, $_); }
	elsif (-l) { print "$_ Is -l\n" if $debug; push(@symlinks, $_);}
	elsif (-S) { print "$_ Is -S\n" if $debug; push(@sockets, $_);}
	elsif (-p) { print "$_ Is -p\n" if $debug; push(@pipes, $_);}
	elsif (-b) { print "$_ Is -b\n" if $debug; push(@blocks, $_);}
	elsif (-c) { print "$_ Is -c\n" if $debug; push(@characters, $_);}
	else       { print "$_ Is... what the heck?\n" if $debug; }
	}

closedir(DIR);

#
#  Process subdirs in the dir (if -R flag used in mactime); crunch, and 
# search it for more dirs...
#
if ($recursion) {
	for (@dirs) {
		# some systems hate symlinks...
		next if (!$follow_dir_sym_links && -l $_);

		# others hate /proc...
		next if (/^\/proc/);

		print "Processing subdir $_\n" if $debug;
		&crunch($_);
		&process_dir($_, 0);
		}
	}

#
# Crunch all the little stuff.  Still need to fix symlinks
#
while (($_=pop(@files))) { print "file $_\n" if $debug; &crunch($_); }
while (($_=pop(@symlinks)))  { print "symlink $_\n"    if $debug; &crunch($_); }
while (($_=pop(@sockets)))   { print "socket $_\n"     if $debug; &crunch($_); }
while (($_=pop(@blocks)))    { print "block file $_\n" if $debug; &crunch($_); }
while (($_=pop(@characters))){ print "character $_\n"  if $debug; &crunch($_); }
while (($_=pop(@pipes)))     { print "pipe $_\n"       if $debug; &crunch($_); }

}
 
sub crunch {
local($file) = @_;

# get rid of extra slashes...
$file =~ s@/+@/@g;

return if (!$file);

return if (-b $file || -c $file);

print "going into crunch... $file, \n" if $debug;

print "crunching dir $dir (in crunch)\n" if $verbose;

($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
$st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = lstat($file);


#
# Linux... *sigh*...
#
$st_blksize = 0 unless $st_blksize;
$st_blocks = 0 unless $st_blocks;

$ls = &faux_ls($file, $st_mode);

# ($x, $y) = split(/\s/, $md5);
($x, $y) = ($md5 =~ /(\S+)\s+(.*)$/);


#
#  The select function call makes normal print's print to that file handle
# instead of STDOUT; I do this rather than write a special tm_print to make
# it print to the body.
#
&tm_print($x,$file,$st_dev,$st_ino,$st_mode,$ls,$st_nlink,
          $st_uid,$st_gid,$st_rdev,$st_size,$st_atime,$st_mtime,
         $st_ctime,$st_blksize,$st_blocks);


#print "$file,$st_dev,$st_ino,$st_mode,$ls,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,$st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks\n";


#
#  Save SGID/SUID file info (no dirs) in a separate file as well -
#

sub faux_ls {
local($file, $mode) = @_;
local($real_file, $ls, $suid, $sgid);

#
#  What is the entry?  Gather it for processing based on type.
# 
# "d"  if file is a directory.
# "b"  if file is a block special file.
# "c"  if file is a character special file.
# "l"  if file is a symbolic link.
# "p"  if file is a named pipe (FIFO).
# "s"  if file is a socket.
# "-"  if file is a plain file.
#
# from the stat man page:
#
# S_IFSOCK   0140000   socket
# S_IFLNK    0120000   symbolic link
# S_IFREG    0100000   regular file
# S_IFBLK    0060000   block device
# S_IFDIR    0040000   directory
# S_IFCHR    0020000   character device
# S_IFIFO    0010000   fifo
# S_ISUID    0004000   set UID bit
# S_ISGID    0002000   set GID bit (see below)
# S_ISVTX    0001000   sticky bit (see below)

# default, can't figure it out ;-)
# $ls = "@";
$ls = "-";
$suid = $sgid = "";

# mostly just copied from stat.h
if    ((($mode) & 0170000) == 0100000) { $ls = "-"; }
elsif ((($mode) & 0170000) == 0040000) { $ls = "d"; }
elsif ((($mode) & 0170000) == 0120000) { $ls = "l"; }
elsif ((($mode) & 0170000) == 0060000) { $ls = "b"; } 
elsif ((($mode) & 0170000) == 0020000) { $ls = "c"; }
elsif ((($mode) & 0170000) == 0010000) { $ls = "p"; }

#
# SUID replaces first "x" with "s"
# SGID replaces second "x" with "S"
#
if    ((($mode) & 0007000) == 0004000) { $suid = "s"; }
if    ((($mode) & 0007000) == 0002000) { $sgid = "S"; }


if ($mode & 000400) { $ls .= "r"; } else { $ls .= "-"; }
if ($mode & 000200) { $ls .= "w"; } else { $ls .= "-"; }
if (!$suid) {
	if ($mode & 000100) { $ls .= "x"; } else { $ls .= "-"; }
	}
else { $ls .= $suid; }

if ($mode & 000040) { $ls .= "r"; } else { $ls .= "-"; }
if ($mode & 000020) { $ls .= "w"; } else { $ls .= "-"; }
if (!$sgid) {
	if ($mode & 000010) { $ls .= "x"; } else { $ls .= "-"; }
	}
else { $ls .= $sgid; }

if ($mode & 000004) { $ls .= "r"; } else { $ls .= "-"; }
if ($mode & 000002) { $ls .= "w"; } else { $ls .= "-"; }
if ($mode & 000001) { $ls .= "x"; } else { $ls .= "-"; }

if (-l $file) {
	$points_to = readlink($file);
	$ls .= " -> $points_to";
	# $real_file = &realpath($file);
	}

print "$file MODE: $mode X $ls\n" if $debug;

return $ls;

}
sub tm_print {
    local(@out) = @_;

    for (@out) {
	s/([^-_`~!@#$^&*()+={}[\]:;"'<>,.?\/a-z0-9 ])/sprintf("%%%02X",unpack("C", $1))/egis;
    }
    print MACTIME join('|', @out),"\n";
}
}
