/*
 * Name and path of the configuration file
 */
#define CONFIG_FILE "/etc/scandetd.conf"

/* 
 * how many hosts should I remember. If your server is heavily loaded it's
 * good idea to increase this number a little bit
 */
#define HOW_MANY 10

/*
 * how many connections should I recognize as scanning?
 */
#define SCAN 20

/* 
 * comment this out to disable printing to log files scan warnings (using syslogd)
 */
#define DOSYSLOG

/* 
 * comment this out if you don't want to log every connection attempt via syslog(tcplog style)
 */
#define LOGCON

/* 
 *  In the table below you can define special ports you want to ignore 
 *  (separated by semicolon):
 *  if 'scanning' started and ended on the same port and this port is equal
 *  to one of the 'ignore_ports' then scan will be ignored. If you notice for example that
 *  your server get a lot of fast connections (from one host) to www port you 
 *  could add to 'ignore_ports'  80 so there will be no false warnings 
 */ 
int ignore_ports[] = {80, 110}; 	/* www and pop3 by default */

/* 
 * If next connection arrive right after the previous one we have to count it.
 * Default time is 1 second.
 */
#define SEC 1

/* 
 * We use this port for sending mail 
 */
#define MAILPORT 25

/* 
 * we send mail to <user@host>: 
 */
char *mail_to = "<root@localhost>";

/* 
 * IP of the machine which sends our mail 
 */
char *mail_host = "127.0.0.1";

/* 
 * mail will be send from host: 
 */
char *from_host = "localhost";

