/************** /USR/SRC/LINUX/KERNEL/SETUID_SYSCALLS.C ********************/
#include <linux/setuid.h>
#include <asm/io.h>
#include <linux/sched.h>
#include <asm/atomic.h>
#include <asm/uaccess.h>

extern int writer_pid; /* process id del processo che sta modificando ACL */ 

extern  eflst_t permitted;	 /* in /fs/setuid_filter.c */
extern  eflst_t failure; 
extern  aclhead_t Header_acl;
extern  int ctrl_active;	
extern  unsigned long ACL_timestamp;
extern  char* put_pw(char *);
extern atomic_access(int*,int);
extern  void* kmalloc(size_t,int);
extern  void kfree(void*);
/*******PROTOTIPAZIONE FUNZIONI ********************/

static int suid_strcmp(char *,char *);
int do_setuid_put(efid_t *,suidpid_t *,int); /* visibile da check_rootproc */
static int sys_setuid_put (efid_t *,suidpid_t *,int );
static int do_setuid_get (eflst_t *,efid_t *,suidpid_t *,mpar_t *);
static int sys_setuid_get (efid_t *,suidpid_t *,mpar_t *);
static int sys_setuid_getheaderacl(aclhead_t *);
static int sys_setuid_putheaderacl(aclhead_t *);
static int delete_psuid_exec(eflst_t *,lsthead_t *,int ,suidpid_t *);
static int do_setuid_delete(eflst_t *,lsthead_t *,efid_t *,suidpid_t *);
static int sys_setuid_delete(efid_t *,suidpid_t *,int );
int sys_setuid_aclm(const int ,aclhead_t *,couple *,mpar_t * );
/********* FINE PROTOTIPAZIONE ************************/

static int suid_strcmp(char * s,char * d){
 while (*s==*d){
   if ( *s=='\0' || *d=='\0' ) break;
  s++;
  d++;
  }
 return *s-*d;
}


int do_setuid_put(efid_t *f,suidpid_t *p,int mode){
  
  int i=0;
  suidp_t *prec_proc=NULL,*punt_proc;
  eflst_t *list;
  lsthead_t *hl;
  efid_t *prova;

  if (mode==PERMITTED) { list=&permitted; hl=&Header_acl.permitted;} 
  else { list=&failure; hl=&Header_acl.failure;} 
  while (i<list->total) {
	prova=&(list->lst[i].efid);
        if ((prova->device==f->device)&&(prova->inode==f->inode)
	  &&(prova->size==f->size)&&(prova->modif==f->modif))
	  break;
	i++;
  }
  if (i<list->total)  {
    punt_proc=list->lst[i].processes; /* punto al primo della lista */
    while (suid_strcmp(punt_proc->suidp_id.comm,p->comm)){ 
       prec_proc=punt_proc;
       punt_proc=punt_proc->next;
       if (punt_proc==NULL) break;
     }  
    if (punt_proc==NULL) {
      punt_proc=(suidp_t *) kmalloc((size_t) sizeof(suidp_t),0);
      if (!punt_proc) 
		return -1; /* not enough memory */
      memcpy(&(punt_proc->suidp_id),p,sizeof(suidpid_t));
      prec_proc->next=punt_proc;
      punt_proc->next=NULL;
      list->lst[i].proc_nr++;
      return PUTPI;   /* inserisco solamente processo ***/
    } else { /* elemento gia' presente nella lista !!!*/
	     if (mode==FAILURE) punt_proc->suidp_id.count++;
                                   /* puo' accadere solo a runtime !!*/
             return PUTAE;      
	   }
    } /* devo inserire processo,se gia' c'e',comunicare con valore di ritorno*/    
      else {  /* devo inserire file e processo */
            if (i<NR_EXE){
              memcpy(&(list->lst[i].efid),f,sizeof(efid_t));
	      punt_proc=(suidp_t *) kmalloc((size_t) sizeof(suidp_t),0);
	      if (!punt_proc) 
			return -1; /* not enough memory */
	      memcpy(&(punt_proc->suidp_id),p,sizeof(suidpid_t));
	      list->lst[i].processes=punt_proc;
	      list->lst[i].proc_nr=1;
	      punt_proc->next=NULL;
	      list->total++;
      	      hl->exe_file_nr=list->total;
              return PUTEP;  /* inseriti file e processo */
            } else return PUTFULL; /* non c'e' piu' spazio nella lista */
          }

   return 0;
}

static int sys_setuid_put (efid_t *file,suidpid_t *process,int mode) {

   return do_setuid_put(file, process,mode);
}

static int do_setuid_get (eflst_t *list,efid_t *f,suidpid_t *p,mpar_t *params){
  suidp_t *suidproc;
  int count;
    
    if (list->total>params->file_nr) {
      suidproc=list->lst[params->file_nr].processes;
      count=0;
      while ((suidproc!=NULL)&&(count!=params->proc_nr)){
	suidproc=suidproc->next;
	count++;
      }
      if ((count==params->proc_nr)&&(suidproc!=NULL)){ /* elemento trovato =>esiste */
       memcpy( f,&(list->lst[params->file_nr]), sizeof(efid_t));
       memcpy( p,suidproc , sizeof(suidpid_t));
       params->timestamp=ACL_timestamp;  
       if (suidproc->next==NULL){ 
	if (params->file_nr==(list->total-1)) return GETLACL;/* ultimo dell'ACL */
	else return GETL; /* ultimo elemento della lista processi */
       } else return GETOK;	
      } else return GETOB; 
    } else return GETOB; /*Out of Boundary =>elemento file_nr,proc_nr inesistente*/
}
/**********************************************************************************
   sys_setuid_get() restituisce
   0 se letto primo elemento e lista non ancora finita
   1 se primo elemento letto e lista finita (era unico elemento della lista)
   2 se lista vuota (nessun elemento letto)
***********************************************************************************/
   
static int sys_setuid_get (efid_t *f,suidpid_t *p,mpar_t *params){
  int error;
  
 if ((params->list==PERMITTED))        
      error=do_setuid_get(&permitted,f,p,params);   
 else if ((params->list==FAILURE))
      error=do_setuid_get(&failure,f,p,params);
 else error=ERR_LIST; /* lista non valida */
 return error;


}


static int  sys_setuid_getheaderacl(aclhead_t *head)  {    
    __constant_copy_to_user(head,&Header_acl, sizeof(aclhead_t));
  
  return 0;
}

static int sys_setuid_putheaderacl(aclhead_t *head) {    

   __constant_copy_from_user( &Header_acl, head, sizeof(aclhead_t)); 
   return 0; 
}

static int delete_psuid_exec(eflst_t *list,lsthead_t *hl,int i,suidpid_t *p){
 suidp_t *p1,*pred;	/* p e' processo da trovare ed elim.*/
 int error;

 p1=list->lst[i].processes;
 pred=p1;
 while (suid_strcmp(p->comm,p1->suidp_id.comm)){
  pred=p1;
  p1=p1->next; 
  if (!p1) break;
 }
 if (p1) { 
  if (pred==p1) list->lst[i].processes=p1->next;
  else pred->next=p1->next;
  kfree((void*) p1);
  error=DELOK; /* proc. p eliminato dalla lista */ 
 } else error=DELN; /* p1==NULL proc_ da eliminare non in lista*/
 if (error==DELOK) 
   if (list->lst[i].proc_nr>1) list->lst[i].proc_nr--;
   else { /* devo eliminare una entry nella lista exe_file */
	if (list->total>1) /* E altri elementi con cui rimpiazzare */
          memcpy(&list->lst[i],&list->lst[list->total-1],sizeof(efile_t)); 
	/* rimpiazzato entry liberata con l'ultima della lista */          
	list->total--;
	hl->exe_file_nr--;
   }
 return error;
}

static int do_setuid_delete(eflst_t *list,lsthead_t *hl,efid_t *f,suidpid_t *p){
 int i=0,error,deleted=0,oldtotal;

 if (f==NULL) { /* cancello tutte le coppie del processo p */ 
   for(;i<list->total;i++) {
    oldtotal=list->total; 
    error=delete_psuid_exec(list,hl,i,p);
    if (list->total<oldtotal) i--; 
    if (error==DELOK) deleted++;    
   } 
   if (deleted) error=deleted;
   else error=DELN;
 } else { /*cancello una sola coppia */ 
     while (i<list->total) {
        if (!memcmp(&(list->lst[i].efid),f,sizeof(efid_t)))  break;
	i++;
     }
     if (i<list->total) {
	error=delete_psuid_exec(list,hl,i,p);
     } else error=DELN; /* la coppia da eliminare non esiste */
 }
 return error;
}
/******************************************************************
  sys_setuid_delete ,ritorna i seguenti valori:

 DELOK 1  : Se coppia eliminata.
 DELN  0  : Se coppia non eliminata poiche' inesistente
 >1 :numero coppie eliminate di uno stesso file eseguibile.

*******************************************************************/
static int sys_setuid_delete(efid_t *f,suidpid_t *p,int mode){
  int error;

 if (mode==PERMITTED)        
      error=do_setuid_delete(&permitted,&Header_acl.permitted,f,p);   
 else error=do_setuid_delete(&failure,&Header_acl.failure,f,p);   

 return error;
}

int  atomic_access(int *paddress, int new_value){

 if (*paddress==0) {
  atomic_add( new_value,(atomic_t *)paddress);
  if (*paddress>new_value){
	 atomic_sub( new_value,(atomic_t *)paddress);
	 return 0; /* busy */ 
  } else return 1; 
 } else return 0; 
}

asmlinkage int sys_setuid_aclm(const int SYSCALL,aclhead_t *head,couple *fp,mpar_t *params){ 
  int error=0,pwd_len=0;
  couple kfp;
  mpar_t kpar;        
  static char passwd[LEN_PWD]; 


  if ((current->uid==0) && (current->euid==0)) 
  switch (SYSCALL)
   { case PUT:{
	       if (writer_pid==0){  	 
		if(atomic_access(&writer_pid,current->pid)) {
			__constant_copy_from_user(&kfp,fp,sizeof(couple)); 		      
			__constant_copy_from_user(&kpar,params,sizeof(mpar_t)); 
	      		error=sys_setuid_put(&kfp.efid,&kfp.suidpid,kpar.list); 
 		        ACL_timestamp++;
 			writer_pid=0;	
                        atomic_access(&writer_pid,0); /* rilascio lock*/ 
                } else return PUTBUSY;
	       } else return PUTBUSY;	
	      }	 break;
     case GET:{  
		  if  (writer_pid!=0) return GETBUSY;
		  else{ 
			__constant_copy_from_user(&kfp,fp,sizeof(couple));
		       	__constant_copy_from_user(&kpar,params,sizeof(mpar_t));
		        error=sys_setuid_get(&kfp.efid,&kfp.suidpid,&kpar);
                        __constant_copy_to_user(fp,&kfp,sizeof(couple));
		        kpar.timestamp=ACL_timestamp;
		        __constant_copy_to_user(params,&kpar,sizeof(mpar_t));
                  }
	      } break;
     case PUTHEADERACL:{ 
	                if (writer_pid==0){  	 
			 if(atomic_access(&writer_pid,current->pid)) {
		          error=sys_setuid_putheaderacl(head);
			  if (ctrl_active) ctrl_active=0;
			  else ctrl_active=1;
			  ACL_timestamp++;
		          writer_pid=0; 
                          atomic_access(&writer_pid,0); /* rilascio lock*/ 
                         } else return PUTBUSY;  
                        } else return PUTBUSY;  
	               } break;
     case GETHEADERACL:{
			 if  (writer_pid!=0) return GETBUSY;
			 else { 
 				error=sys_setuid_getheaderacl(head);
		       		kpar.timestamp=ACL_timestamp;
		       		__constant_copy_to_user(params,&kpar,sizeof(mpar_t));
                   	 }
	      		} break;
     case DELETE:{
	         if (writer_pid==0){  
		  if(atomic_access(&writer_pid,current->pid)) {
			__constant_copy_from_user(&kfp,fp,sizeof(couple)); 		      
			__constant_copy_from_user(&kpar,params,sizeof(mpar_t));
 			if ((kfp.efid.inode==0)&&(kfp.efid.device==0)){
			  error=sys_setuid_delete(NULL,&kfp.suidpid,kpar.list); 
			} else 
		          error=sys_setuid_delete(&kfp.efid,&kfp.suidpid,kpar.list); 
	       		ACL_timestamp++;  	     	    
			writer_pid=0;
                        atomic_access(&writer_pid,0); /* rilascio lock*/ 
        	    } else return DELBUSY;
                 } else return PUTBUSY;
	          } break;
     
     case PUTPWD:{
	         if (writer_pid==0){  	
		  if(atomic_access(&writer_pid,current->pid)) {
		    __constant_copy_from_user(&kpar,params,sizeof(mpar_t));
		    __constant_copy_from_user(passwd,kpar.passwd,LEN_PWD);
		    put_pw(passwd);
		    pwd_len=strlen(passwd);
		    memset(&passwd,(int)'\0',pwd_len);
		    /* cancellata password dalla variabile appoggio !!! */
		    __constant_copy_to_user(passwd,kpar.passwd,pwd_len);
		    writer_pid=0;
                    atomic_access(&writer_pid,0); /* rilascio lock*/ 
		    /* cancellata password anche nello spazio utente !!!*/
                  } else return PUTBUSY;
                 } else return PUTBUSY;
		 } break;      
     default:error=NO_DEFINED_SERVICE; 
   }	
 else return -EPERM; /* no permessi sufficienti */
  return error;
}
