/*******  /usr/src/linux/include/linux/setuid.h  *********************************
 ** Questo file contiene la dichiarazione dei tipi di dati utilizzati		**
 ** per implementare il prototipo di monitoraggio dei processi SETUID.		**
 ** Deve essere incluso sia nei sorgenti del kernel (kernel/setuid_syscall.c ,  **
 ** ...fs/setuid_filter.c) contenenti le routine che effettuano i controlli 	**
 ** a runtime, sia dai sorgenti dei processi utente=root ,quali : 		**
 ** /setuid_patch/setuid_loadacl e setuid_writeacl        		        **
 *********************************************************************************/

#include <linux/tasks.h>
#include <linux/kernel.h>
#include <linux/fs.h> 
#include <asm/posix_types.h>


#define ACLPATHNAME "/etc/bop/acl"      /* bop :Buffer Overflow Patch */
#define NR_EXE 	99 			/* dimensione statica dei due array  */
#define BOP_LEVEL KERN_WARNING  	/* buffer overflow patch level */
#define LEN_PWD 128 			/* lunghezza max spazio riservato password root */
/**** VALORI RITORNO setuid_filter.o:check_rootproc *********/
#define PSA  	0 			/* OK proc.setuid a root autorizzato eseg. file*/
#define EXENA	2 			/* setuid non autorizzato eseguire file */
#define EFNA	1 			/* file non autenticato */
#define PNS     3 			/* processo non setuid a root */
/*** COSTANTI PER LA MODALITA DI PUTACL E GETACL  ************/
#define PERMITTED 0
#define FAILURE 1
#define ERR_LIST -1
/***************************************************************/
/** PUTACL **/
#define PUTEP 0 	/* ok <EXE,PSUID> inseriti correttamente */
#define PUTPI 1 	/* inserisco solo processo:exe gia presente */
#define PUTAE 3 	/* <EXE,PSUID> already exist */
#define PUTFULL 6 	/* ecceduto NR_SUID_EXE */
#define PUTBUSY 7 	/* c'e' una modifica in corso */
/** GETACL  **/
#define GETOK 0  	/*OK GET Again ,ci sono altre coppie */
#define GETL 1  	/*OK Get Last ,ultimo elemento della lista */
#define GETLACL 2 	/*OK ultimo elemento dell'ACL*/
#define GETOB  3   	/* out boundary : elemento inesistente */
#define GETBUSY 4
/** DELETEACL ***/
#define DELOK 1 	/* un elemento eliminato */
#define DELN  0 	/* non esiste elemento da eliminare */
#define DELBUSY -1
/****************************************************************/   
/**************** SYSTEM CALLS ROUTING	**************************/
#define PUT	0
#define GET	1
#define PUTHEADERACL  2
#define GETHEADERACL  3
#define DELETE  4
#define PUTPWD  5 
#define NO_DEFINED_SERVICE 5

/****************************************************************/    
#define IS_SETUID_TO_ROOT(proc) !((proc)->euid)&&(proc)->uid
#define IS_A_ROOT_DAEMON(proc)  !((proc)->euid)&&((proc)->tty==NULL)
#define NOT_DEV_PROC_VAR(file) (strncmp("/dev/",file,5)&&strncmp("/proc/",file,6)&&strncmp("/var/",file,5))
 
struct list_header{
 unsigned long exe_file_nr;  		/* file executable number */
} ; 
struct  acl_header{
	unsigned int version; 		/* non ancora usata */
	struct list_header permitted; 	/* files eseguibili accreditati */
        struct list_header failure;  	/* tentativi di esecuzione falliti */ 
} ;
struct setuid_proc_id{
 char comm[16];     
 unsigned long count;
};

struct  setuid_process { 
	struct setuid_proc_id suidp_id; /* inf. identif. univoca(?) processo*/
	struct setuid_process * next;	/* prossimo processo */
}; 
struct exe_file_id {
	__kernel_dev_t   device; /* device number   */
 	unsigned long inode; 		/* inode number  */
	__kernel_off_t size; /*  dimensione */
        __kernel_time_t modif;/* data della ultima modifica  */
}; 
struct  executable_file {
 	struct exe_file_id efid; 	/*informazioni identificazione univoca del file */   	
	int proc_nr; 			/* numero totale processi autorizzati ad invocarlo*/
        struct setuid_process  *processes;/* lista dei processi autorizzati*/
};

struct executable_file_list  {
	struct executable_file lst[NR_EXE];
	unsigned int total; 		/* numero file_exe in tabella */
};

struct more_param{
 unsigned char list; 
 unsigned char file_nr; 
 unsigned char proc_nr; 
 char *passwd; /* utilizzata solamente per inserire (e mai leggere) *
		* l'immagine della password di root		    *
		*/
 unsigned long timestamp;/* incrementato ad ogni modifica */
};

typedef struct executable_file efile_t;
typedef struct executable_file_list  eflst_t;
typedef struct setuid_process  suidp_t ;
typedef struct acl_header  aclhead_t;
typedef struct list_header lsthead_t;
typedef struct exe_file_id  efid_t;
typedef struct setuid_proc_id suidpid_t;
struct efile_suidp{
        efid_t efid;
	suidpid_t suidpid;
};
typedef struct efile_suidp couple; 	/* coppia : <file_exe,psuid> */
typedef struct more_param mpar_t;
extern unsigned char acl_modified; 	/* non ancora usato */
