
#include <linux/setuid.h>
#include <linux/stat.h>
#include <linux/mm.h>
#include <asm-i386/fcntl.h>
#include <linux/sched.h>

/* 
  ATTENZIONE:
  Manterremo in memoria due strutture gemelle ,ovvero, i due array
  chiamati : faccr  ed  ifall .
  faccr,e' la lista dei file accreditati ai processi	set_uid.
  Mentre ifall e' la lista degli eseguibili invocati  dai processi
  set_uid e di cui si e' bloccata l'esecuzione perche' non accreditati  
  rispetto al processo invocante.
*/

eflst_t  permitted; /* accreditati*/
eflst_t  failure;  /* falliti */
aclhead_t Header_acl;
int ctrl_active=0;	/* controlli non attivi per default*/
static char rpasswd[LEN_PWD];
unsigned long ACL_timestamp; /* aggiornato ad ogni modifica */
int writer_pid=0;

extern int do_setuid_put(efile_t *,suidp_t *,int); /*  kernel/setuid_syscalls.c   */
extern int atomic_access(int*,int);
struct wait_queue *pid_queue=NULL;

/******************************************************************************
 check_rootproc(..) invocata da do_execve(..) restituisce i seguenti valori:

  PSA=0 : se FILE EXE da eseguire e' nel database e puo' essere 
      	  invocato dal processo corrente (ovvero qyello invocante )

  EFNA=1 : se FILE EXE esiste nel database per il processo corrente
	   ma non e' autenticato dalla data di creazione/modifica

  ESUIDNA=2 : se il FILE EXE non esiste nel database per il processo
	   corrente.

  PNS=3 : processo corrente non e' processo setuid,quindi non sottoposto a
	 restrizioni.
*******************************************************************************/

int check_rootproc(struct inode *ino)
 { 
   int cont=0,iproc=0,error=0;
   suidp_t * suidproc;   
   efile_t f; 
   suidp_t p; 

   if ((IS_SETUID_TO_ROOT(current)||IS_A_ROOT_DAEMON(current))&&(ctrl_active)){
      printk("BOP Exec: uid=%d euid=%d tty=%p\n",current->uid,current->euid,current->tty);
      for (;cont<permitted.total;cont++) {
	if((permitted.lst[cont].efid.device==ino->i_dev)&&(permitted.lst[cont].efid.inode==ino->i_ino)) {
          if((permitted.lst[cont].efid.size==ino->i_size)&&(permitted.lst[cont].efid.modif==ino->i_mtime)) 
         {
	    suidproc=permitted.lst[cont].processes;
	    for (iproc=1;iproc<=permitted.lst[cont].proc_nr;iproc++)  {
		 if (!strcmp(suidproc->suidp_id.comm,current->comm)) { 
			suidproc->suidp_id.count++;
                        return PSA;
		 }  
		if (iproc<permitted.lst[cont].proc_nr) suidproc=suidproc->next;
	    } 	    
         }  else { 
		   error=EFNA; /* non sono autenticate date creaz./modifica*/
		   goto file_exe_unauthorized; 
  		 }
       } 	
      } 
     error=EXENA; /* FILE EXE non esiste nel database  */
     goto file_exe_unauthorized;
  } 

   return PNS; /* processo corrente non e' setuid */

   file_exe_unauthorized:
		     f.efid.device=ino->i_dev;
                     f.efid.inode=ino->i_ino;
		     f.efid.size=ino->i_size; 
                     f.efid.modif=ino->i_mtime; 
                     strncpy(p.suidp_id.comm,current->comm,sizeof(p.suidp_id.comm));
                     p.suidp_id.count=1; /* considerato solo se coppia non in lista */
		     do {
			while (writer_pid!=0){
			  cli(); /* interrupt disabled */
			  if (writer_pid!=0) 
			    interruptible_sleep_on(&pid_queue);
			  sti();	
			}	
		     } while (!atomic_access(&writer_pid,current->pid));
		     /* inizio sezione critica */
		     do_setuid_put(&(f.efid),&(p.suidp_id),FAILURE);
 		     writer_pid=0; /* fine sezione crititca */
		     atomic_access(&writer_pid,0); /* rilascio lock */
                     return error;
 }
  
int check_integrity_acl(void){  

	return 0;
}
char* get_pw(char* pwd){ /* get crypted password  */
  strncpy(pwd,rpasswd,LEN_PWD);
  pwd[LEN_PWD-1]='\0';
 return pwd;
 
}
char*  put_pw(char* pwd){
 return strncpy(rpasswd,pwd,LEN_PWD);

}

/****************************************************************************
  init_setuidacl() deve essere invocata in fase di avvio,
                          precedentemente al caricamento del 
			  database da disco.
*****************************************************************************/
 
void init_setuidacl(void){   
  Header_acl.version=1;
  Header_acl.permitted.exe_file_nr=0;
  Header_acl.failure.exe_file_nr=0;
  permitted.total=0;
  failure.total=0;
  rpasswd[0]='\0';
} 
