
#include <stdio.h> 
#include <stddef.h> 
#include "setuid_syscall.h"    
#define  COM_WRITE 0
#define  COM_LOAD  1
#define  COM_LIST  2

int read_list(eflst_t *,mpar_t *);
int read_acl(aclhead_t *,eflst_t *,eflst_t *);
void stampa_header_lista(lsthead_t *);
void stampa_header(aclhead_t *);
void stampa_coppia(efile_t *,suidp_t *);
void stampa_lista( eflst_t *);
int write_acl(eflst_t *,FILE *); 
int write(aclhead_t *,eflst_t *,eflst_t *);
  
int insert_couple(eflst_t *list,couple *fp,suidp_t **last_proc,int last_file){
 suidp_t *proc;

 if (*last_proc==NULL) { /* debbo inserire un nuovo file_exe */
		 memcpy(&(list->lst[last_file].efid),&fp->efid,sizeof(efid_t));
		 list->total++;
		 list->lst[last_file].proc_nr=1;
		 (*last_proc)=(suidp_t *) malloc(sizeof(suidp_t));
		 memcpy(*last_proc,&(fp->suidpid),sizeof(suidpid_t));
		 list->lst[last_file].processes=*last_proc;
		 (*last_proc)->next=NULL;
                } else { 
			 proc=(suidp_t *) malloc(sizeof(suidp_t));
			 memcpy(proc,&(fp->suidpid),sizeof(suidpid_t));
			 proc->next=NULL;
			 (*last_proc)->next=proc;
			 *last_proc=(*last_proc)->next;
		}		  
 return 0; 
}


int read_list(eflst_t *list,mpar_t *param){
 int error,end_list,last_file;
 suidp_t *last_proc;
 couple fp;
 long oldtimestamp;

 param->file_nr=param->proc_nr=end_list=last_file=0;
 last_proc=NULL;
 list->total=0;

 while (!end_list){
  oldtimestamp=param->timestamp;
  do {  
	error=setuid_aclm(GET,NULL,&fp,param);
  } while (error==GETBUSY);
  if (param->timestamp>oldtimestamp) return TO_RESTART;
  switch (error)
  { case GETOK:{insert_couple(list,&fp,&last_proc,last_file);
		param->proc_nr++;
	       } break;
    case GETL:{insert_couple(list,&fp,&last_proc,last_file); 
               last_file=++param->file_nr; param->proc_nr=0;
	       last_proc=NULL;
	      } break;
    case GETLACL:{
		  insert_couple(list,&fp,&last_proc,last_file); 
		  end_list=1;
		  error=0; /* don't restart */
		} break;
    case GETOB:end_list=1;
               break;    
    default: end_list=1; /* problemi con valori ritorno syscall*/
	break;
  }
 } /* while fine lista */ 
 return error; /* il valore ci dice se dobbiamo riiniziare a leggere */
} 

int read_acl(aclhead_t *head,eflst_t *accr,eflst_t *fall){
 mpar_t param;
 int risultato,error;
 long timestamp;
  couple fp;

 error=TO_RESTART; /* la prima volta debbo comunque leggere */
 
 while (error==TO_RESTART) {
   do {
    risultato=setuid_aclm(GETHEADERACL,head,&fp,&param);
   } while (risultato==GETBUSY);
   param.list=PERMITTED;
   if (TO_RESTART==(error=read_list(accr,&param))) continue;
   param.list=FAILURE;
   if (TO_RESTART==(error=read_list(fall,&param))) continue;
 }  
   
}
  

/* METTERE TALI FUNZIONI COME EXTERN E LINKARLE !!!!!*/ 
void stampa_header_lista(lsthead_t *l){
 printf("	tot.file exe :%d \n ",l->exe_file_nr);
} 

void stampa_header(aclhead_t *h){
 printf(" 	HEADER INFO ACL \n");
 printf("\n PERMITTED :");
 stampa_header_lista(&h->permitted);
 printf("\n FAILURE :");
 stampa_header_lista(&h->failure);
 printf("\n");
}
void stampa_coppia(efile_t *f,suidp_t *p){
    printf(" PROC=%s C=%d :",p->suidp_id.comm,p->suidp_id.count);  
    printf(" EXE: I=%d D=%d",f->efid.inode,f->efid.device);
    printf(" S=%d M=%d\n",f->efid.size,f->efid.modif); 
}

void stampa_lista( eflst_t *list){
 int file;
 suidp_t *proc_suid;
   
   for (file=0;file<list->total;file++){
   proc_suid=list->lst[file].processes;
   while (proc_suid!=NULL){
    stampa_coppia(&list->lst[file],proc_suid); 
    proc_suid=proc_suid->next;
   }
  }

} 
int list(aclhead_t *head,eflst_t *accr,eflst_t *fall){
 int risultato;
  
  risultato=read_acl(head,accr,fall);
  stampa_header(head);
  printf("	PERMITTED LIST\n");
  stampa_lista(accr);
  printf("	FAILURE LIST \n");
  stampa_lista(fall);

 return risultato;
}
/*********************************  INIZIA WRITE ***********************/
 int write_acl(eflst_t *list,FILE *f){ 
 	int risultato=0,nr_proc=0,i=0; 
        suidp_t *process; 

	for (i=0;(i<list->total);i++) { 
	    fwrite(&list->lst[i],sizeof(efile_t),1,f);
	    process=list->lst[i].processes; 
	    while (process!=NULL) { 
	        fwrite(process,sizeof(suidp_t),1,f); 
   		process=process->next;
            }
 	}
    /********************************************************************** 
     * attenzione non viene piu' utilizzato il campo			  *
     * list->lst[i].proc_nr ,infatti, per determinare fine lista processi *
     * si utilizzano solamente i confronti sui valori NULL dei puntatori  *
     **********************************************************************/
  return 0;
}
  
int write(aclhead_t *head,eflst_t *accr,eflst_t *fall){
 int risultato=0; 
 efile_t file_exe; 
 suidp_t process; 
 FILE *acl_setuid; 
  
 risultato=read_acl(head,accr,fall);
 acl_setuid=fopen(ACLPATHNAME,"wb"); /* apro file read binary */ 

 risultato=fwrite(head,sizeof(aclhead_t),1,acl_setuid); 
 printf("	PERMITTED LIST\n");
 risultato=write_acl(accr,acl_setuid);
 printf("	FAILURE LIST\n"); 
 risultato=write_acl(fall,acl_setuid);  
 fclose(acl_setuid);   

 return 0;	 
}
/******************************** FINISCE WRITE ************************/

/******************************** INIZIA LOAD **************************/
int load_acl(lsthead_t *list,FILE *file,int mode){ 
 	int error,i;
	static suidp_t process;
        suidp_t *next_proc; 
	efile_t file_exe; 
        couple fp;
	mpar_t par;

	par.list=mode; /* altri valori ininfluenti in questo caso */
	for (i=0;(i<list->exe_file_nr);i++) {
	    par.file_nr=i;
	    par.proc_nr=0; 
	    fread(&file_exe,sizeof(efile_t),1,file);
	    next_proc=(suidp_t*) file_exe.processes;
 	    while (next_proc!=NULL){
	        fread(&process,sizeof(suidp_t),1,file);
		/* estraggo da file_exe,process solamente *
		 * le informazioni ,eliminando i puntatori*
		 */
		memcpy(&fp.efid,&file_exe,sizeof(efid_t));
		memcpy(&fp.suidpid,&process,sizeof(suidpid_t));  
	/* decidere se azzerare count priorita **********************/    
                error=setuid_aclm(PUT,NULL,&fp,&par); 
		par.proc_nr++; /* predispongo per successivo */
                next_proc=(suidp_t*) process.next;
	    }  
        } 
        return 0;  
}  

 
int load(aclhead_t *head){ 
  
 char account[200]; /* buffer per lettura account su shadow password */ 
 FILE *acl_setuid; 
 FILE *shadow_password;
 int root_found,end_file,error;
 char *lettura,*username,*password,*userid,*end_uid;
 static couple fp; 
 static mpar_t par;
 

 acl_setuid=fopen(ACLPATHNAME,"rb"); /* apro file read binary */ 
 error=fread(head,sizeof(aclhead_t),1,acl_setuid);
 shadow_password=fopen("/etc/shadow","rb");
 /*********** prelevo immagine password root ********************/
 root_found=0;
 end_file=0;
 while ((!root_found)&&(!end_file)) {
  lettura=fgets(account,sizeof(account),shadow_password);
  if (lettura!=NULL) {
	username=lettura;
	password=(char *) strchr(lettura,':'); /* deve essere root */ 	
	*password='\0'; /* termino a \0 username */
	password++; /* punto al primo carattere di password */
	userid=(char *)strchr(password,':'); /* questo lo leggo per saltarlo */
	*userid='\0';
	userid++;
	userid=(char *) strchr(userid,':')+1; /* deve essere 0 se root */
	end_uid=(char *) strchr(userid,':');
	*end_uid='\0';
	/* non serve terminare a \0 userid */
  } else end_file=1;
  root_found=!strncmp("root",username,sizeof("root"));
 }
 if (root_found) { 
  if (strlen(password)>LEN_PWD) {
	printf("password troppo lunga !!\n");
	par.passwd=(char *)"none";
  } else{
	par.passwd=password;
  }
 }
 error=setuid_aclm(PUTPWD,NULL,NULL,&par);/* inserisco password in kernel */
 /* a questo punto la password e' stata cancellata dallo spazio utente */
 error=setuid_aclm(PUTHEADERACL,head,NULL,NULL);  
 error=load_acl(&head->permitted,acl_setuid,PERMITTED); 
 error=load_acl(&head->failure,acl_setuid,FAILURE);  
 fclose(acl_setuid);  

 return 0;	 
}  
void print_usage(void){
 printf("usage : aclmng [options]\n");
 printf(" options: -v :verbose \n");
 printf("          -h --help :print this message \n");
 printf("one of : -L --load :load acl from file %s\n",ACLPATHNAME);
 printf("         -w --write:write acl to file %s\n",ACLPATHNAME);
 printf("         -l --list :list acl (verbose automatic) \n");
 printf(" DEFAUTL : aclmng --list \n\n"); 
}  

/******************************** FINISCE LOAD *************************/

int main (int argc,char *argv[]){ 
  eflst_t accr,fall;
  aclhead_t head;
  int i,risultato;
  unsigned char verbose,command;
  efid_t prova;
 

  if (argc>1){
    for (i=1;i<argc;i++){
      if (strcmp(argv[i],"-v")==0) verbose=1;
      else if ((strcmp(argv[i],"-h")==0)||(strcmp(argv[i],"--help")==0)) 
				print_usage();
      else if ((strcmp(argv[i],"-L")==0)||(strcmp(argv[i],"--load")==0))
				command=COM_LOAD;
      else if ((strcmp(argv[i],"-l")==0)||(strcmp(argv[i],"--list")==0))
				command=COM_LIST;
      else if ((strcmp(argv[i],"-w")==0)||(strcmp(argv[i],"--write")==0))
				command=COM_WRITE;
      else { printf("unknow option %s\n",argv[i]);
	     printf(" 'aclmng -h'  or 'aclmng --help' to view usage \n");
	     break;
      }	
    }
  } else { verbose=0; /* default */
  	   command=COM_LIST; 	
  }
  switch (command){
   case COM_LIST:{risultato=list(&head,&accr,&fall);
             } break;

   case COM_WRITE:{risultato=write(&head,&accr,&fall); 
   	      } break;
  
   case COM_LOAD:{risultato=load(&head);
	     } break;
  }
 printf("\n");
 return 0;
}
