/* carbonite.c	(c) 2001 Foundstone	Kevin Mandia and Keith Jones
*
*  version: 0.1b 20010130.00
*	- creates a /tmp/CARBONITE directory
*	- retrieves an executbable copy of all running processes
* 	- creates a file similar to the ps command as CARBONITE.txt
*       - lists environment variables, args, and open files in CARBONITE.txt
*       - lists open sockets and pipes in CARBONITE.txt
*	- see README.txt for other features.	
*  This LKM was designed as a follow up to the work of 
*  Dominique Brezinski and his cryogenic tool - hence the 
*  name 'carbonite'. This LKM 'freezes' process information normally 
*  provided in the Linux proc_fs. It "raises the bar" by identifying 
*  all running processes, regardless of a trojanized ps command or a
*  LKM rootkit such as knark or heroin, which both intercept the 'kill'
*  system call and hide a process from sys admins.
*
*  All rights granted for commercial and non-commercial use.
*/

#define MODULE
#define __KERNEL__

#include<linux/module.h>
#include<linux/config.h>
#include<linux/version.h>
#include<linux/kernel.h>
#include<linux/sched.h>
#include<linux/proc_fs.h>
#include<linux/mman.h>
#include<linux/mm.h>
#include<linux/file.h>
#include<linux/stat.h>
#include<asm/uaccess.h>
#include<asm/semaphore.h>
#include<asm/pgtable.h>
#include<linux/mc146818rtc.h>
#include<linux/time.h>
#include"io.c"
#include"array.c"
#include"pgtable.c"
#include"open.c"
#include"strings.c"

/* Total number of valid process flags available in linux */

#define	PF_TOTALNUM	13

/* All defined process flags in linux, defined in task_struct in sched.h*/ 

const unsigned long valid_flags[PF_TOTALNUM] = 
				    { PF_ALIGNWARN, PF_STARTING,
			              PF_EXITING, PF_PTRACED,
			              PF_TRACESYS, PF_FORKNOEXEC,
			              PF_SUPERPRIV, PF_DUMPCORE,
			              PF_SIGNALED, PF_MEMALLOC,
			              PF_VFORK, PF_USEDFPU,
			              PF_DTRACE };

/* This is the path of where results will be stored */

#define FILENAME_PREFIX1	"/tmp/CARBONITE/"

/* This is the size of a max temp string */

#define TMP_STRING_MAXLEN	500

/* This is the identity of captured information */

#define FILENAME_PREFIX2 	"CARBONITE."

/* This is the total Directory Depth Carbonite will traverse for open files */

#define MAX_DIR_DEPTH		100	

/* Writes an exe image out of the tast virtual memory */

int save_exe_image( struct task_struct *p ) 
{
  char filename[TMP_STRING_MAXLEN], 
       tmpstr[TMP_STRING_MAXLEN];
  struct file *pidfilefd;
  unsigned char c;
  struct mm_struct *mm = p->mm;
  struct vm_area_struct *vma = mm->mmap;
  int readbytes;
  mm_segment_t fs;

  /* Build the valid filenames */

  filename[0] = '\0';
  tmpstr[0] = '\0';
  strcat( filename, FILENAME_PREFIX1 );
  strcat( filename, FILENAME_PREFIX2 );
  strcat( filename, p->comm );
  sprintf( tmpstr, ".%d", p->pid );
  strcat( filename, tmpstr );

  /* Use the kernel function to open the files */

  pidfilefd = filp_open( filename, O_CREAT, S_IRWXU | S_IRWXG | S_IRWXO );

  pidfilefd->f_count++;
  fs = get_fs();
  set_fs( KERNEL_DS );

  /* Search through the virtual mem pages, find the exe, copy to filename */

  mm = p->mm;
  if (mm) 
  {
    vma = mm->mmap;
    for (vma = mm->mmap; vma; vma = vma->vm_next)
    {
      if ( (vma->vm_flags & VM_EXECUTABLE) && vma->vm_file ) 
      {
        vma->vm_file->f_pos = 0;
	readbytes = vma->vm_file->f_op->read( vma->vm_file, &c, sizeof(c), &vma->vm_file->f_pos );
        while (readbytes != 0) 
        { 
          pidfilefd->f_op->write( pidfilefd, &c, sizeof(c), &pidfilefd->f_pos );
	  readbytes = vma->vm_file->f_op->read( vma->vm_file, &c, sizeof(c), &vma->vm_file->f_pos );
        }
      } 
    }   
  }
  set_fs( fs );
  fput( pidfilefd );

  filp_close( pidfilefd, 0 );

  return 1;
}

/* Searches task_struct for a PID with invalid flag settings */
/* and writes all information to the text files */

void *find_special_tasks(void)
{  
  struct file *resultsfile, *tmpfile;
  struct dentry *tmpdir;
  char resultsfilename[TMP_STRING_MAXLEN],
       arg_buff[TMP_STRING_MAXLEN],
       env_buff[TMP_STRING_MAXLEN],
       tmpstr[TMP_STRING_MAXLEN],
       strbuff[TMP_STRING_MAXLEN];
  char c;
  struct qstr *dirnames[MAX_DIR_DEPTH];
  int readbytes, total_dir_depth, skip_next_slash, i, j, k;
  mm_segment_t fs;
  struct mm_struct *mm;
  struct vm_area_struct *vma;

  struct task_struct *p, *p_start;  
  unsigned long valid_mask = 0; 

  struct rtc_time rtc_tm;
  unsigned char ctrl;

  int days_ago, hours, mins, secs;
  unsigned long curr_jiffs, curr_secs, time_diff;

  struct timeval curr_time;

  unsigned char days_in_mo[] = {31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
 
  /* Build a process flag mask that is considered valid */

  i = 0;  
  while ( i < PF_TOTALNUM ) 
  {
    valid_mask |= valid_flags[i]; 
    i++;
  }

  /* Write the output to a file */
  
  resultsfilename[0] = '\0';
  strcat( resultsfilename, FILENAME_PREFIX1 );
  strcat( resultsfilename, FILENAME_PREFIX2 );
  strcat( resultsfilename, "txt" );

  fs = get_fs();
  set_fs( KERNEL_DS );

  resultsfile = filp_open( resultsfilename, O_CREAT, 
			S_IRWXU | S_IRWXG | S_IRWXO );
  resultsfile->f_count++;

  curr_jiffs = jiffies;

  rtc_tm.tm_sec = CMOS_READ(RTC_SECONDS);
  rtc_tm.tm_min = CMOS_READ(RTC_MINUTES);
  rtc_tm.tm_hour = CMOS_READ(RTC_HOURS);
  rtc_tm.tm_mday = CMOS_READ(RTC_DAY_OF_MONTH);
  rtc_tm.tm_mon = CMOS_READ(RTC_MONTH);
  rtc_tm.tm_year = CMOS_READ(RTC_YEAR);
  ctrl = CMOS_READ(RTC_CONTROL);

  if (!(ctrl & RTC_DM_BINARY) || RTC_ALWAYS_BCD)
  {
    BCD_TO_BIN(rtc_tm.tm_sec);
    BCD_TO_BIN(rtc_tm.tm_min);
    BCD_TO_BIN(rtc_tm.tm_hour);
    BCD_TO_BIN(rtc_tm.tm_mday);
    BCD_TO_BIN(rtc_tm.tm_mon);
    BCD_TO_BIN(rtc_tm.tm_year);
  }
  
  curr_secs = rtc_tm.tm_sec + rtc_tm.tm_min * 60 + rtc_tm.tm_hour * 3600 +
              rtc_tm.tm_mday * 86400;

  for ( i = 0; i < rtc_tm.tm_mon; i++ )
  {
    curr_secs = curr_secs + days_in_mo[i] * 86400; 
  }

  curr_secs = curr_secs + (30 + rtc_tm.tm_year) * 86400 * 365;

  curr_secs = curr_secs + 86400 + ( (30 + rtc_tm.tm_year) / 4) * 86400;

  sprintf( strbuff, "CURRENT LOCAL TIME: %02d-%02d-%02d %02d:%02d:%02d\n\n", 
           rtc_tm.tm_mon, rtc_tm.tm_mday, rtc_tm.tm_year, rtc_tm.tm_hour, 
           rtc_tm.tm_min, rtc_tm.tm_sec );
  resultsfile->f_op->write( resultsfile, strbuff, 
                            strlen(strbuff), &resultsfile->f_pos );

  sprintf( strbuff, "PID\tH?  UID\tSTAT\t\tCOMM\tSTART TIME (Jiffies)\n" );
  resultsfile->f_op->write( resultsfile, strbuff, 
                            strlen(strbuff), &resultsfile->f_pos );

  set_fs( fs );

  /* Compare each process to see if it has a valid process flag state */
  
  p = p_start = current;
  do 
  { 
    time_diff = curr_secs - (curr_jiffs/HZ) + (p->start_time / HZ);

    days_ago = (p->start_time / HZ) / 86400; 

    time_diff = time_diff % 86400;
    
    hours = time_diff / 3600;
    time_diff = time_diff % 3600;
    mins = time_diff / 60;
    secs = time_diff % 60;

    if (p->flags & ~valid_mask) 
    {
      sprintf( strbuff, "%u\tY %5u\t%s\t%s\t%d Days ago at %02d:%02d:%02d (%lu)\n", 
               p->pid, p->uid, get_task_state(p), p->comm, days_ago, 
               hours, mins, secs, p->start_time );
    } else 
    {  
      sprintf( strbuff, "%u\tN %5u\t%s\t%s\t%d Days ago at %02d:%02d:%02d (%lu)\n", 
               p->pid, p->uid, get_task_state(p), p->comm, days_ago, 
               hours, mins, secs, p->start_time );
    }
    fs = get_fs();
    set_fs( KERNEL_DS );
    resultsfile->f_op->write( resultsfile, strbuff, 
                              strlen(strbuff), &resultsfile->f_pos );
    set_fs( fs );
    save_exe_image( p );
    p = p->next_task;
  } while (p != p_start);

  fs = get_fs();
  set_fs( KERNEL_DS );
  p = p_start = current;
  do 
  {
    mm = p->mm;
    if (mm != NULL && mm->mmap != NULL) 
    {
      vma = mm->mmap;

      /* Build the Environment, Arg, and open files file */

      tmpstr[0] = '\0';
      sprintf( tmpstr, "\n\n****         ");
      resultsfile->f_op->write( resultsfile, tmpstr, 6*sizeof(char), &resultsfile->f_pos );
      tmpstr[0] = '\0';
      sprintf( tmpstr, "\nPID: %u                               ",p->pid);
      resultsfile->f_op->write( resultsfile, tmpstr, 15*sizeof(char), &resultsfile->f_pos );

      tmpstr[0] = '\0';
      sprintf( tmpstr, "\nCOMMAND: %s                               ",p->comm);
      resultsfile->f_op->write( resultsfile, tmpstr, 30*sizeof(char), &resultsfile->f_pos );

      tmpstr[0] = '\0';
      strcat( tmpstr, "\nARGS: ");
      resultsfile->f_op->write( resultsfile, tmpstr, 7*sizeof(char), &resultsfile->f_pos );
      readbytes = get_array(p, p->mm->arg_start, p->mm->arg_end, arg_buff);
  
      i = 0;
      while ( i < readbytes )
      {
	// Change null to newline
	if (arg_buff[i] == '\0')
	{
		c = '\n';
		// Throw away repetitive nulls
		while ( i + 1 < readbytes && arg_buff[i+1] == '\0' )
			i++;
	} else
        	c = arg_buff[i];
        resultsfile->f_op->write( resultsfile, &c, sizeof(c), &resultsfile->f_pos );
        i++;
      }
  
      tmpstr[0] = '\0';
      strcat( tmpstr, "\n\nENV: ");
      resultsfile->f_op->write( resultsfile, tmpstr, 7*sizeof(char), &resultsfile->f_pos );
      readbytes = get_array(p, p->mm->env_start, p->mm->env_end, env_buff);
  
      i = 0;
      while ( i < readbytes )
      {
	// Change null to newline
	if (env_buff[i] == '\0')
	{
		c = '\n';
		// Throw away repetitive nulls
		while ( i + 1 < readbytes && env_buff[i+1] == '\0' )
			i++;
	} else
        	c = env_buff[i];
        resultsfile->f_op->write( resultsfile, &c, sizeof(c), &resultsfile->f_pos );
        i++;
      }
  
      /* Capture the Open File Descriptors */
      if (p->files != NULL) 
      {  
        tmpstr[0] = '\0';
        strcat( tmpstr, "\n\nFILES: ");
        resultsfile->f_op->write( resultsfile, tmpstr, 9*sizeof(char), &resultsfile->f_pos );
        for (i=0; p->files->fd[i] != NULL; i++) {
          tmpstr[0] = '\0';
          sprintf( tmpstr, "\n%d:                ", i);
          resultsfile->f_op->write( resultsfile, tmpstr, 8*sizeof(char), &resultsfile->f_pos );
          tmpfile = p->files->fd[i];
          tmpdir = tmpfile->f_dentry;
          j = 0;
    
          while (tmpdir != NULL && j < MAX_DIR_DEPTH)
          {
            dirnames[j] = &(tmpdir->d_name);
            j++;
            if (tmpdir->d_parent != NULL && tmpdir->d_inode != NULL && tmpdir->d_parent->d_inode != NULL )
            {
              if (tmpdir->d_inode->i_ino == tmpdir->d_parent->d_inode->i_ino )
              {
                break;
              }
            }
            tmpdir = tmpdir->d_parent;
          }
          total_dir_depth = j;
    
          for (j=total_dir_depth-1; j >= 0; j--)
          {
            if (dirnames[j]->name[0] != '/' && skip_next_slash == 0)
            {
              c = '/';
              resultsfile->f_op->write( resultsfile, &c, sizeof(c), &resultsfile->f_pos );
            } else if (dirnames[j]->name[0] != '/' && skip_next_slash != 0 )
            {
              skip_next_slash = 0;
            } else
            {
              skip_next_slash = 1;
            }
            for (k=0; k < dirnames[j]->len; k++ )
            {
              c = dirnames[j]->name[k];
              resultsfile->f_op->write( resultsfile, &c, sizeof(c), &resultsfile->f_pos );
            }
          }
    
          tmpstr[0] = '\0';
          if (tmpfile->f_dentry->d_inode != NULL)
          {
            if (S_ISFIFO( tmpfile->f_dentry->d_inode->i_mode ))
            {
              sprintf( tmpstr, "\npipe number: %lu                                    ", tmpfile->f_dentry->d_inode->i_ino);
              resultsfile->f_op->write( resultsfile, tmpstr, 25*sizeof(char), &resultsfile->f_pos );
            } else if (S_ISSOCK( tmpfile->f_dentry->d_inode->i_mode ))
            {
              sprintf( tmpstr, "\nsocket number: %lu                                  ", tmpfile->f_dentry->d_inode->i_ino);
              resultsfile->f_op->write( resultsfile, tmpstr, 26*sizeof(char), &resultsfile->f_pos );
            } else
            {
              sprintf( tmpstr, "\ninode number: %lu                                   ", tmpfile->f_dentry->d_inode->i_ino);
              resultsfile->f_op->write( resultsfile, tmpstr, 25*sizeof(char), &resultsfile->f_pos );
            }
          } 
        }
      }
      tmpstr[0] = '\0';
      sprintf( tmpstr, "\n****         ");
      resultsfile->f_op->write( resultsfile, tmpstr, 5*sizeof(char), &resultsfile->f_pos );
    }
      p = p->next_task;
  } while (p != p_start);
  set_fs( fs );
 
  fput( resultsfile );

  filp_close( resultsfile, 0 );
}

/* Module Init Code */
int init_module (void) 
{
  printk(KERN_INFO "\nCARBONITE Inserted - by Foundstone, Inc. www.foundstone.com\n");
  printk(KERN_INFO "\nCARBONITE Processing...\n" );
  find_special_tasks();
  return(0);
}

/* Module Cleanup Code */
void cleanup_module (void)
{
  printk(KERN_INFO "\nCARBONITE Removed - by Foundstone, Inc. www.foundstone.com\n");
}
