/****
 * soclog.h
 *  - This file contains the headers for the routines for logging 
 *    usage of Socket Demon. If logging is not 'turning on' via
 *    the define LOG_TO_DEATH then this file willbe null.
 ****/

#ifndef _SOCLOG_H_
#define _SOCLOG_H_

#include "socdefs.h"

#ifdef LOG_TO_DEATH

typedef struct {
  unsigned char class;
  unsigned char netid;
  unsigned char subnetid;
  unsigned char hostid;
} dotted_quad;

/* ok ok, I know that the fields aren't really class,net,sub,host  */
/* as above, but that's about as close as you can fit them for the */
/* dotted quad format, and class two addresses are pretty close to */
/* that format..                                                   */

/* now a structure for log records.. */
typedef enum {
  accepting_connection,
  bad_password,
  connection_closed,
  killed_by_command
} t_log_type;

extern boolean log_to_file;
extern boolean command_log;
extern char log_file[PROG_SPEC_LEN];
extern char cmd_log_file[PROG_SPEC_LEN];
extern dotted_quad client_dotted_q;
extern char dotted_4_str[20];
extern char log_string[MAX_OUTPUT_LEN];

extern void log_stuff ();
extern void log_command();

#endif /* LOG_TO_DEATH */

#endif /* _SOCLOG_H_ */
