#include "yp-tools.h"

bool_t
ytxdr_domainname(XDR *xdrs, char **objp)
{
  if (!xdr_string(xdrs, objp, 1024)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
ytxdr_ypbind_binding(XDR *xdrs, struct ypbind_binding *objp)
{
  if (!xdr_opaque(xdrs, (char *)&objp->ypbind_binding_addr, 4)) {
    return (FALSE);
  }
  if (!xdr_opaque(xdrs, (char *)&objp->ypbind_binding_port, 2)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
ytxdr_ypbind_resptype(XDR *xdrs, enum ypbind_resptype *objp)
{
  if (!xdr_enum(xdrs, (enum_t *)objp)) {
    return (FALSE);
  }
  return (TRUE);
}

bool_t
ytxdr_ypbind_resp(XDR *xdrs, struct ypbind_resp *objp)
{
  if (!ytxdr_ypbind_resptype(xdrs, &objp->ypbind_status)) {
    return (FALSE);
  }
  switch (objp->ypbind_status) {
  case YPBIND_FAIL_VAL:
    if (!xdr_u_int(xdrs, &objp->ypbind_respbody.ypbind_error)) {
      return (FALSE);
                 }
    break;
  case YPBIND_SUCC_VAL:
    if (!ytxdr_ypbind_binding(xdrs, &objp->ypbind_respbody.ypbind_bindinfo)) {
      return (FALSE);
    }
    break;
  default:
    return (FALSE);
  }
  return (TRUE);
}

