#include <stdio.h>
#include <stdarg.h>
#include <string.h>


#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netdb.h>
#include <netinet/in.h>

#include "mnt.h"

#include <sys/mount.h>
#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#include <rpc/pmap_prot.h>
#include <nfs/nfs.h>
#include <rpcsvc/mount.h>

static char *progname;

void
fatal (char *fmt, ...)
{
  va_list ap;

  fprintf (stderr, "%s: ", progname);
  va_start (ap, fmt);
  vfprintf (stderr, fmt, ap);
  va_end (ap);
  exit (1);
}



static inline int
atoxd (char c)
{
  if (c >= '0' && c <= '9')
    return (c - '0');
  c = tolower (c);
  if (c >= 'a' && c <= 'f')
    return (c - 'a' + 10);
  fatal ("Bad hex digit %c\n", c);
}

char *
init_nfsargs (char *target, char *portstr, struct nfs_args *nfsargsp)
{
  struct hostent *hp;
  char *path;


  static struct sockaddr_in saddr;
  int nfsport = 0;

  bzero (nfsargsp, sizeof (struct nfs_args));
  if (! (path = (strchr (target, ':'))))
    fatal ("no ':' in target %s\n", target);
  *path = '\0';
  path++;
  if (! (hp = gethostbyname (target)))
    fatal ("no host %s\n", target);
  memcpy ((void *) &saddr.sin_addr, hp->h_addr, hp->h_length);
  saddr.sin_family = AF_INET;
  if (portstr)
    nfsport = atoi (portstr);
  if (nfsport) {
    saddr.sin_port = htons (nfsport);



  } else {
    saddr.sin_port = htons(PMAPPORT);
    if (! (nfsport = pmap_getport (&saddr, NFS_PROGRAM,
                                  NFS_VERSION, IPPROTO_UDP)))
      fatal ("%s\n", clnt_spcreateerror ("getport NFS"));
    printf ("nfs port = %d\n", (int) nfsport);
    saddr.sin_port = nfsport;
  }
  nfsargsp->addr = (struct sockaddr_in *) &saddr;
  nfsargsp->hostname = target;
#ifdef NFS_ARGS_NETNAME
  nfsargsp->netname = target;
#endif /* NFS_ARGS_NETNAME */
  nfsargsp->flags |= NFSMNT_SOFT | NFSMNT_INT | NFSMNT_NODEVS
    | NFSMNT_HOSTNAME;
#ifndef NO_FSNAME


  nfsargsp->fsname = path;
#endif /* NO_FSNAME */
  return (path);
}

int
set_fh (char *path, char *fhstr, struct nfs_args *nfsargsp)
{
  CLIENT *clp;
  struct timeval rtry;
  int so = RPC_ANYSOCK;
  enum clnt_stat clnt_stat;
  struct sockaddr_in saddr;
  static struct fhstatus fhs;

  if (! fhstr) {


    bzero (&saddr, sizeof (saddr));
    saddr.sin_family = AF_INET;
    memcpy ((void *) &saddr.sin_addr,
           (void *) &((struct sockaddr_in *)nfsargsp->addr)->sin_addr,
           sizeof (saddr.sin_addr));
    rtry.tv_sec = 10;
    rtry.tv_usec = 0;
    if (! (clp = clntudp_create (&saddr, MOUNTPROG, MOUNTVERS, rtry, &so)))
      fatal ("%s\n", clnt_spcreateerror ("MOUNT create"));
    if ((clnt_stat = clnt_call (clp, MOUNTPROC_MNT, xdr_path,
                               &path, xdr_fhstatus,
                               &fhs, rtry))
       != RPC_SUCCESS)
      fatal (clnt_sperror (clp, "MNT RPC"));
#if 1
    if ((clnt_stat = clnt_call (clp, MOUNTPROC_UMNT, xdr_path,


                               &path, xdr_void, NULL, rtry))
       != RPC_SUCCESS)
      fatal (clnt_sperror (clp, "UMNT RPC"));
#endif
    if (fhs.fhs_status)
      fatal ("mount RPC failed\n");
  } else {
    int i = 0, j = 0;
    unsigned char *p = (char *) &fhs.fhs_fh;

    while (i < NFS_FHSIZE && fhstr[j] && fhstr[j+1]) {
      if (fhstr[j] == '-') {
       j++;
       continue;
      }
      p[i++] = (atoxd (fhstr[j])<<4) | atoxd (fhstr[j+1]);


      j += 2;
    }
    if (i != NFS_FHSIZE || fhstr[j])
      fatal ("invalid number of characters in fh\n");
  }
  nfsargsp->fh = (void *) &fhs.fhs_fh;
  printf ("fh = ");
  {
    int i;
    unsigned char *p = (char *) &fhs.fhs_fh;

    for (i = 0; i < NFS_FHSIZE; i++) {
      if (i && ! (i % 4))
       printf ("-");
      printf ("%02x", (int) p[i]);
    }


  }
  printf ("\n");
  return (0);
}


int
main (int argc, char **argv)
{
  struct nfs_args nfsargs;
  struct nfs_args *nfsargsp = &nfsargs;
  char *path;

  if (progname = strrchr (argv[0], '/'))
    progname++;
  else


    progname = argv[0];
  if (argc < 2 || argc > 5) {
    fprintf (stderr, "usage: %s host:fs [dst-path [fh [port]]]\n",
            progname);
    exit (1);
  }

  path = init_nfsargs (argv[1], argc > 4 ? argv[4] : NULL, nfsargsp);
  set_fh (path, argc > 3 ? argv[3] : NULL, nfsargsp);
  if (argc > 2
      && vfsmount (MOUNT_NFS, argv[2], M_NEWTYPE | M_NOSUID,
                  (caddr_t) nfsargsp) != 0) {
    perror (argv[2]);
    exit (1);
  }
  exit (0);


}
