/* tool-b.c
 *
 * v1.1 21/05/2000 (c) codex@bogus.net
 *
 * this code is dependent on libnet; get it at www.packetfactory.net
 *
 * big greetings to fake and maelstrom. hi to the spies team. and the big
 * canadian w/broken palm device.
 *
 */

#define ERRBUFSIZE 256
#define TOOL_DATASIZE 184
#define MSG_START 20
#define SNAPLEN LIBNET_IP_H+LIBNET_TCP_H+TOOL_DATASIZE

#include <libnet.h>

unsigned char packet[SNAPLEN];
unsigned char tcp_data[TOOL_DATASIZE];
unsigned char msg[TOOL_DATASIZE-MSG_START];

/* usage() ----------------------------------------------------------------- */

void usage(void) {
  fprintf(stdout,"tool-b v1.1 21/05/2000 (c) codex@bogus.net\n");
  fprintf(stdout,"usage: tool-b [-h] [-s <source>] [-a <srcport>] [-b <dstport>] -t <target>\n");
  fprintf(stdout,"\t -h : this\n");
  fprintf(stdout,"\t -a : source port (defaults to random)\n");
  fprintf(stdout,"\t -b : destination port (defaults to random)\n");
  fprintf(stdout,"\t -s : source (NAT address or random), default: random\n");
  fprintf(stdout,"\t -t : target (target gateway if target behind NAT)\n");
}

/* SendPacket() -- construct packet and send it ---------------------------- */

int SendPacket(int network, unsigned long src_ip, 
	       unsigned long dst_ip, unsigned short src_port,
	       unsigned short dst_port, unsigned char *device,
	       unsigned char *payload) {

  int sent,seqno,ackno;
 
  seqno=rand();
  ackno=rand();

  /* build something which resembles a valid ip header */

  if(!src_ip) src_ip=rand()%0xff;

  libnet_build_ip(LIBNET_TCP_H,
		  IPTOS_LOWDELAY,
		  rand()%0xff,
		  0,
		  48,
		  IPPROTO_TCP,
		  src_ip,
		  dst_ip,
		  payload,
		  TOOL_DATASIZE,
		  packet);
		  
  /* now build the TCP header */

  libnet_build_tcp(src_port,      
		   dst_port,             
		   seqno,               
		   ackno,                 
		   TH_ACK,                
		   1024,                  
		   0,                     
		   tcp_data,                   
		   TOOL_DATASIZE,         
		   packet + LIBNET_IP_H); 

  /* calculate IP and TCP checksums */

  if((libnet_do_checksum(packet,IPPROTO_TCP,
			 TOOL_DATASIZE+LIBNET_TCP_H))<0) {
    fprintf(stderr,"error: libnet_do_checksum: failed on ip\n");
  }
  if((libnet_do_checksum(packet,IPPROTO_IP,
			 TOOL_DATASIZE+LIBNET_IP_H+LIBNET_TCP_H))<0) {
    fprintf(stderr,"error: libnet_do_checksum: failed on ip\n");
  }

  /* send data -- a sw-3 discovery packet is 74 bytes */

  sent=libnet_write_ip(network,packet,SNAPLEN);

  return(sent);

}

/* the big cheesy enchilada which is probably not so big, but works ------- */

int main (int argc, char *argv[]) {

  int c,sent,station,network;
  int error=0;
  int stop=0;

  char errbuf[ERRBUFSIZE];
  char *device = NULL;

  unsigned long dst_ip=0;
  unsigned long src_ip=0;

  unsigned short src_port=0;
  unsigned short dst_port=0;

  unsigned short src_id=rand()%0xffff;
  unsigned short dst_id=rand()%0xffff;
  
  srand(getpid()); 

  /* what does the user really want?? get some clue from the command line */

  while((c = getopt(argc,argv,"s:t:a:b:S:D:h")) != EOF) {
    switch(c) {
    case 't':
      if ((dst_ip = libnet_name_resolve(optarg, 1)) == -1) {
	fprintf(stderr,"error: can't resolve host '%s'\n",optarg);
	exit(1);
      }
      break;
    case 's':
      if ((src_ip = libnet_name_resolve(optarg, 1)) == -1) {
	fprintf(stderr,"error: can't resolve host '%s'\n",optarg);
	exit(1);
      }
      break;
    case 'S':
      src_id=atoi(optarg);
      break;
    case 'D':
      dst_id=atoi(optarg);
      break;
    case 'a':
      src_port=atoi(optarg);
      break;
    case 'b':
      src_port=atoi(optarg);
      break;
    case 'h':
      usage();
      exit(0);
    default:
      usage();
      exit(1);
    }
  }

  if(!src_port) src_port=rand()%0xffff;
  if(!dst_port) dst_port=rand()%0xffff;

  if(!src_id || !dst_id) {
    fprintf(stderr,"Error: need source and destination ID (see tool-a for details)\n");
    exit(1);
  }

  /* bail out if no destination ip or device is given */

  if(!dst_ip) {
    usage();
    exit(1);
  }

  if(!src_ip) {src_ip=rand();}

  if((network = libnet_open_raw_sock(IPPROTO_RAW))<0) {
    fprintf(stderr,"ERROR: can't open raw socket (are you root?)\n");
    exit(1);
  }
  
  fprintf(stderr,"Enter messages, quit with ^D on a blank line.\n");

  /* grab a message from the keyboard, send encoded payload */

  while(!stop) {
    bzero(msg,sizeof(msg));
    fgets(msg,(sizeof(msg)-MSG_START),stdin);

    /* copy TOOL identifier + header info into tcp data (payload) */

    memcpy(tcp_data,"TOOL",4);
    memcpy(tcp_data+4,&src_id,2);
    memcpy(tcp_data+6,&dst_id,2);
    memcpy(tcp_data+8,&src_ip,4);
    memcpy(tcp_data+12,&dst_ip,4);
    memcpy(tcp_data+16,"\0\0\0\0",4);  /* optional data */

    if(msg[0]==0x00) {
      stop=1;
      memcpy(tcp_data+MSG_START,"TOOL-B JUST QUIT\n",17);
      sent=SendPacket(network,src_ip,dst_ip,src_port,dst_port,device,tcp_data);
    } else {
      
      /* copy message into data (tcp data section, the actual payload) */

      memcpy(tcp_data+MSG_START,msg,sizeof(msg));

      /* send packet */

      sent=SendPacket(network,src_ip,dst_ip,src_port,dst_port,device,tcp_data);

      if(sent<SNAPLEN) {
	fprintf(stderr,"WARNING: only wrote %d bytes (should have been %d)\n",
		sent,SNAPLEN);
	if(error) {
	  fprintf(stderr,"ERROR: giving up!\n");
	  break;
	}
	error++;
      }
    }
  }

  if (libnet_close_raw_sock(network) == -1) {
    fprintf(stderr,"ERROR: failed to close raw socket - wtf?\n");
    exit(1);
  }

  fprintf(stdout,"Goodbye.");

  return(0);
}















