use vars qw(@ISA @EXPORT @EXPORT_OK);

use Exporter;
@ISA=qw(Exporter);
@EXPORT=qw(
rand_set rand_ip rand_port rand_mac listen_info connect_info regex list_sock_err con_sock_err
);


# Here are most of the subs...

# Call the other random subs...
sub rand_set {
 if($rsport==1 || $rdport==1) {
     rand_port();
     if($protocol==6) {
      $packet->set({ tcp  => { source => $sport, dest   => $dport } });
     } elsif($protocol==17) {
        $packet->set({ udp  => { source => $sport, dest   => $dport } });
     }
 }

 if($rsip==1) {
  rand_ip();
  $packet->set({ ip   => { saddr => $saddr } });
 }
 
 if(defined($ethdev) && ($rems==1||$remd==1)) {
  rand_mac();
  $packet->ethset(source => $smac, dest => $dmac);
 }

}

# Random IP address...
sub rand_ip {
 srand;
 return $saddr=(int rand 255).".".(int rand 255).".".(int rand 255).".".(int rand 255);
}

# Random ports...
sub rand_port {
 srand;
 if(defined($rsport) && $rsport==1)   { $sport   =(int rand $field) }
 if(defined($rdport) && $rdport==1)   { $dport   =(int rand $field) }
 if(defined($connect) && $connect==0) { $connect =(int rand $field) } 
 if(defined($listen) && $listen==0)   { $listen  =(int rand $field) }
}

# Random MAC address...
# (taken from an Net::RawIP example: macof)
sub rand_mac {
 my $tmp_mac="00";
 my $i=0;

 if(defined($rems)) {
  while($i++ < 5) {
   $tmp_mac.=":" . sprintf("%x",int rand 16);
   $tmp_mac.=sprintf("%x",int rand 16);
  }
  $smac=$tmp_mac;
 }

 if(defined($remd)) {
  while($i++ < 5) {
   $tmp_mac.=":" . sprintf("%x",int rand 16);
   $tmp_mac.=sprintf("%x",int rand 16);
  }
  $dmac=$tmp_mac;
 }
}

# Exit on CTRL-C
sub ctrl_exit {
 print("\n\nCTRL-C caught...exiting.\n\n");
 exit(0);
}

# Show network device(s) and exit...
sub show_net_dev {
 $addrlist=ifaddrlist;
 print("\nNetwork devices:\n");
 print("----------------\n");

 # This line is taken from an Net::RawIP example (iflist)...
 map { print "$_->$addrlist->{$_}\n" } keys %$addrlist;
 print("\n");
 exit(0);
}

# Print some information (--listen)
sub listen_info {
 if(!defined($quiet)) {
  print("Listening on port: $listen\n");
  if(defined($regex))  { print("Matching         : $regex\n")  }
  if(defined($nregex)) { print("Not matching     : $nregex\n") }
  print("\n");
 }
} 

sub connect_info {
 if(!defined($quiet)) {
  print("Connected to: $daddr($connect)\n");
  if($d_unset!=1) {
   print("Sending: $data\n\n");
  } else { print("\n") }
 }
}

sub regex {
 if(!defined($quiet)) {
 
  if($sop==17) {
   print("$rhost($rport): ");
  }
  
  if(!defined($regex) && !defined($nregex)) {
   print $cldata;
  } elsif(defined($regex) && defined($nregex)) {
     if($cldata=~/$regex/ && $cldata!~/$nregex/) {
     print $cldata;
    }
  } elsif(defined($regex) && !defined($nregex)) {
     if($cldata=~/$regex/) { print $cldata }
  } elsif(defined($nregex) && !defined($regex)) {
     if($cldata!~/$nregex/) { print $cldata }
  }
 }
} 

sub list_sock_err {
 die("Error: Unable to initialize socket !!!\n");
}

sub con_sock_err  {
 die("Error: Unable to connect to host: $daddr !!!\n");
} 

1;
