use vars qw(@ISA @EXPORT @EXPORT_OK);

use Exporter;
@ISA=qw(Exporter);
@EXPORT=qw(check_socket so_define sock_listen sock_connect);


# Socket functions..
sub check_socket {
 if(defined($listen) && defined($connect)) { help(3) }
 
 if(defined($listen))  { so_define(); sock_listen($listen) }
 if(defined($connect)) { so_define(); sock_connect($connect) }
}


# We call this sub to include IO::Socket, to set
# random ports and to print warnings (if needed).
sub so_define {
 use IO::Socket;
 
 # Print a warning, if someone uses --listen and
 # specifies a destination ip (only if !defined($quiet)) !
 if(defined($listen) && defined($daddr) && !defined($quiet)) {
  warn("Warning: Dest. IP($daddr) will be ignored (listen function) !!!\n");
 }
 
 # Check if someone specified a socket protocol other
 # than TCP(6) or UDP(17) and if so, we die with an error.
 if($sop!=6 and $sop!=17) { help(4) }
 
 # Set random ports
 rand_port();
}


sub sock_listen {

 # TCP server
 if($sop==6) {
  my($server, $client);
  
  # Setting up socket...
  $server=IO::Socket::INET->new(LocalPort => $listen,
                                Proto     => $sop,
				Reuse     => 1,
				Listen    => 1
			       ) or list_sock_err();
 
  # Print some information...
  listen_info();
  
  if($client=$server->accept()) {
   while(1) {
    $client->recv($cldata, 1024);
    
    # Print data and check $regex/$nregex
    regex();
   }
  }
  
 }
 
 if($sop==17) {
  my($server);
  $server=IO::Socket::INET->new(LocalPort=>$listen,
                               Proto    =>'udp'
                               ) or list_sock_err();				
   
  # Print some information...
  listen_info();
   
  while($server->recv($cldata, 1)) {
   my($rport, $ipaddr)=sockaddr_in($server->peername);
   $rhost=gethostbyaddr($ipaddr, AF_INET);

   # Print data and check $regex/$nregex
   regex(); 
  }  
 }
  
 # Exit apsend
 exit(0);
}


sub sock_connect {
 my($client, $ipaddr, $portaddr);
 
 # Connect over TCP...
 if($sop==6) {
  $client=IO::Socket::INET->new(Proto    => "tcp",
                                PeerAddr => $daddr,
				PeerPort => $connect
			       ) or con_sock_err();

  connect_info();
  
  # $cldata=$data if $data is defined ($d_undef==0)
  if($d_undef==1) {
   while($cldata=<STDIN>) {
    $client->send($cldata);
   }
  } else {
     $client->send($data);
  }
 }
 
 # "Connect" over UDP :)
 if($sop==17) {
  $client=IO::Socket::INET->new(Proto    => "udp") or con_sock_err();
  $ipaddr=inet_aton($daddr);
  $portaddr=sockaddr_in($connect, $ipaddr);
  
  connect_info();
  
  # $cldata=$data if $data is defined ($d_undef==0) 
  if($d_undef==1) {
   while($cldata=<STDIN>) {
   send($client, $cldata, 0, $portaddr)==length($cldata);
   }
  } else {
     send($client, $data, 0, $portaddr)==length($data);
  }
 }

 # Exit apsend
 exit(0);
} 

1;
