
/* This is part of xspy, written by Jon A. Maxwell.  This part takes
   the keycode and makes an output string. */

#include <X11/Xlib.h>
#include <X11/X.h>

#include <string.h>
#include <stdio.h>

#include "xspy.h"

/* Have a keycode, Look up keysym for it.
   Convert keysym into its string representation.
   if string is more than one character try to reduce it to one.
   if string still is more than one character, put it into the form
    (+string) or (-string) depending on whether the key is up or down.
   print out the string.
                                     */



struct conv {char from[20], to[5];} conv_table[] = {
	/* shift & control replaced with nothing, since they are appearent
	   from the output */
	{"return","\n"},	{"escape","^["},	{"delete", "^H"},
	{"shift",""},		{"control",""},		{"tab","\t"},
	{"space", " "},		{"exclam", "!"},	{"quotedbl", "\""},	
	{"numbersign", "#"},	{"dollar", "$"},	{"percent", "%"},
	{"ampersand", "&"},	{"apostrophe", "'"},	{"parenleft", "("},	
	{"parenright", ")"},	{"asterisk", "*"},	{"plus", "+"},
	{"comma", ","},		{"minus", "-"},		{"period", "."},	
	{"slash", "/"},		{"colon", ":"},		{"semicolon", ";"},	
	{"less", "<"},		{"equal", "="},		{"greater", ">"},	
	{"question", "?"},	{"at", "@"},		{"bracketleft", "["},
	{"backslash", "\\"},	{"bracketright", "]"},	{"asciicircum", "^"},	
	{"underscore", "_"},	{"grave", "`"},		{"braceleft", "{"},	
	{"bar", "|"},		{"braceright", "}"},	{"asciitilde", "~"},	
	{"",""}
	};
int StrToChar(char *data) {
	int i=0;
	while (conv_table[i].from[0]!=0 || conv_table[i].to[0]!=0) {
		if (!strncasecmp(data,conv_table[i].from,
				strlen(conv_table[i].from)) ) {
			strcpy(data,  conv_table[i].to);
			return TRUE;
			}
		i++;
		}
	return FALSE;
	}

char *KeyCodeToStr(int code, int down, int mod) {
	static char	*str, buf[KEYSYM_STRLEN+1];
	int	index;
	KeySym	keysym;
	
	/* get the keysym for the appropriate case */
	     if (mod==SHIFT_DOWN) index=SHIFT_INDEX;
	else index=0;
	keysym=XKeycodeToKeysym(disp, code, index);
	if (NoSymbol==keysym) return "";

	/* convert keysym to a string, copy it to a local area */
	str=XKeysymToString(keysym);
	if (NULL==str) return "";
	strncpy(buf, str, KEYSYM_STRLEN); buf[KEYSYM_STRLEN]=0;

	/* try to reduce strings to character equivalents */
	if (buf[1]!=0 && !StrToChar(buf)) {
		/* still a string, so put it in form (+str) or (-str) */
		if (down) strcpy(buf, "(+");
		else      strcpy(buf, "(-");
		strcat(buf, str);
		strcat(buf, ")");
		return buf;
		}
	if (buf[0]==0) return "";
	if (mod==CONTROL_DOWN) {
		buf[2]=0;
		buf[1]=toupper(buf[0]);
		buf[0]='^';
		}
	if (mod==LOCK_DOWN) {buf[0]=toupper(buf[0]);}
	return buf;
	}


/* returns which modifier is down, shift/caps or control */
int KeyModifiers(char *keys) {
	static int setup=TRUE;
	static int width;
	static XModifierKeymap *mmap;
	int i;
	
	if (setup) {
		setup=FALSE;
		mmap=XGetModifierMapping(disp);
		width=mmap->max_keypermod;
		}
	for (i=0; i<width; i++) {
		KeyCode code;

		code=mmap->modifiermap[ControlMapIndex*width+i];
		if (code && 0!=BIT(keys, code)) {return CONTROL_DOWN;}

		code=mmap->modifiermap[ShiftMapIndex*width  +i];
		if (code && 0!=BIT(keys, code)) {return SHIFT_DOWN;}

		code=mmap->modifiermap[LockMapIndex*width   +i];
		if (code && 0!=BIT(keys, code)) {return LOCK_DOWN;}
		}
	return 0;
	}
