#include <sys/socket.h>
#include <sys/types.h>
#include <stdio.h>
#include <netinet/in.h>
#include <netinet/udp.h>
#include <netinet/ip.h>
#include <netdb.h>
#include "rpc_msg.h"

#define IPHDRSIZ sizeof(struct iphdr)
#define UDPHDRSIZ sizeof(struct udphdr)
#define PSEUDOSIZ sizeof(struct pseudohdr)

/*      Create a rpchdr.
 *
 *      usage: mkrpchdr(xid,prog,vers,proc,point_to_put_header);
 *      returns size of rpchdr + auth.
 */
int mkrpchdr(unsigned long xid,
         unsigned long prog,
         unsigned long vers,
         unsigned long proc,
         char *buf)
 {
    struct rpchdr *rpc;
    unsigned long *auth;

    rpc = (struct rpchdr *)buf;
    auth = (long *)(buf + sizeof(struct rpchdr)); 
    
    rpc->xid        = htonl(xid);
    rpc->msg_type   = 0;
    rpc->rpcvers    = htonl(2);
    rpc->prog       = htonl(prog);
    rpc->vers       = htonl(vers);
    rpc->proc       = htonl(proc);

    /* Create AUTH_NULL headers */
    *(auth++) = htonl(0); /* AUTH_NULL */
    *(auth++) = htonl(0); /* sizeof(opaque) = 0 */
    *(auth++) = htonl(0); /* AUTH_NULL */
    *(auth++) = htonl(0); /* sizeof(opaque) = 0 */

    return (sizeof(struct rpchdr) + (4 * sizeof(long)));
}

unsigned short chksum(unsigned short *addr, int len)
{
    register int nleft = len;
    register unsigned short *w = addr;
    register int sum = 0;
    unsigned short answer = 0;

    while(nleft > 1)
    {
        sum += *w++;
        nleft -= 2;
    }

    if(nleft == 1)
    {
        *(unsigned char *)(&answer) = *(unsigned char *)w;
        sum += answer;
    }

    sum = (sum >> 16) + (sum & 0xffff);
    sum += (sum >> 16);
    answer = ~sum;
    return(answer);
}

unsigned long rand_ip()
{
    char tmp[20];

    sprintf(tmp,"%d.%d.%d.%d",rand() % 255,
                              rand() % 255,
                              rand() % 255,
                              rand() % 255);
    return inet_addr(tmp);
}

struct pseudohdr
{
  unsigned long saddr;
  unsigned long daddr;
  char useless;
  unsigned char protocol;
  unsigned short length;
};

int send_udp(int sock, unsigned long saddr, unsigned short sport,
             unsigned long daddr, unsigned short dport, char *data,int datasize)
{
    int ret;
    struct sockaddr_in sin;
    struct pseudohdr *pseudo;
    struct udphdr *udp;
    struct iphdr *ip;
    char *packet,*pdata;

    packet = (char *)malloc(IPHDRSIZ + UDPHDRSIZ + datasize);
    if(!packet)
    {
        printf("Malloc error\n");
        exit(-1);
    }

    ip     = (struct iphdr *)packet;
    pseudo = (struct pseudohdr *)(packet + IPHDRSIZ - PSEUDOSIZ);
    udp    = (struct udphdr *)(packet + IPHDRSIZ);
    pdata  = (char *)(packet + IPHDRSIZ + UDPHDRSIZ);

    memset(packet,NULL,IPHDRSIZ + UDPHDRSIZ + datasize);
    if(data && datasize) memcpy(pdata,data,datasize);

    pseudo->saddr    = saddr;
    pseudo->daddr    = daddr;
    pseudo->useless  = 0;
    pseudo->protocol = IPPROTO_UDP;
    pseudo->length   = htons(UDPHDRSIZ + datasize);

    udp->source = htons(sport);
    udp->dest   = htons(dport);
    udp->len    = htons(UDPHDRSIZ + datasize);
    udp->check  = chksum((u_short *)pseudo,PSEUDOSIZ + UDPHDRSIZ + datasize);

    ip->version = 4;
    ip->ihl     = 5;
    ip->tos     = 0;
    ip->tot_len = htons(IPHDRSIZ + UDPHDRSIZ + datasize);
    ip->id      = htons(random());
    ip->frag_off= 0;
    ip->ttl     = 255;
    ip->protocol= IPPROTO_UDP;
    ip->saddr   = saddr;
    ip->daddr   = daddr;
    ip->check   = chksum((u_short *)packet,IPHDRSIZ);

    sin.sin_addr.s_addr = daddr;
    sin.sin_family = AF_INET;

    ret = sendto(sock,packet,IPHDRSIZ + UDPHDRSIZ + datasize,0,(struct sockaddr *)&sin,sizeof(struct sockaddr));
    free(packet);
    return ret;
}
unsigned long resolve(char *name)
{
  struct hostent *hp;
  unsigned long ip;

  if((ip = inet_addr(name)) == -1)
  {
    if((hp = gethostbyname(name)) == NULL)
    {
        printf("Unable to resolve <%s>\n",name);
        exit(-1);
    }
    memcpy(&ip,hp->h_addr,4);
  }
  return ip;
}
